/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.util;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.function.Executable;
import org.junit.platform.commons.util.UnrecoverableExceptions;
import org.junit.platform.engine.TestExecutionResult;

public class ThrowableCollector {
    private final List<Throwable> throwables = Collections.synchronizedList(new ArrayList());
    private final boolean printStackTrace;

    public ThrowableCollector() {
        this.printStackTrace = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Executable executable) {
        Throwable throwable = null;
        try {
            executable.execute();
        }
        catch (Throwable t) {
            throwable = t;
        }
        if (throwable != null) {
            if (throwable instanceof InvocationTargetException) {
                throwable = throwable.getCause();
            }
            if (this.printStackTrace) {
                PrintStream printStream = System.out;
                synchronized (printStream) {
                    PrintStream printStream2 = System.err;
                    synchronized (printStream2) {
                        throwable.printStackTrace();
                    }
                }
            }
            UnrecoverableExceptions.rethrowIfUnrecoverable((Throwable)throwable);
            this.throwables.add(throwable);
        }
    }

    public boolean isEmpty() {
        return this.throwables.isEmpty();
    }

    public boolean isNotEmpty() {
        return !this.throwables.isEmpty();
    }

    public List<Throwable> getThrowables() {
        return this.throwables;
    }

    public TestExecutionResult toTestExecutionResult() {
        if (this.isEmpty()) {
            return TestExecutionResult.successful();
        }
        return TestExecutionResult.failed((Throwable)this.throwables.get(0));
    }
}

