/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.coze.datasource;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.annotation.AnylineComponent;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.coze.datasource.CozeClient;
import org.anyline.data.coze.runtime.CozeRuntimeHolder;
import org.anyline.data.datasource.DataSourceHolder;
import org.anyline.data.datasource.init.AbstractDataSourceHolder;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.runtime.RuntimeHolder;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.util.BasicUtil;

@AnylineComponent(value="anyline.environment.data.datasource.holder.Coze")
public class CozeDataSourceHolder
extends AbstractDataSourceHolder
implements DataSourceHolder {
    private static final CozeDataSourceHolder instance = new CozeDataSourceHolder();

    public static CozeDataSourceHolder instance() {
        return instance;
    }

    public CozeDataSourceHolder() {
        DataSourceHolder.register((Object)DatabaseType.Coze, (DataSourceHolder)this);
    }

    public String reg(String key, String prefix) {
        try {
            String url;
            if (BasicUtil.isNotEmpty((Object)prefix) && !prefix.endsWith(".")) {
                prefix = prefix + ".";
            }
            if (BasicUtil.isEmpty((Object)(url = (String)this.value(prefix, params, "url", String.class, null)))) {
                return null;
            }
            String adapter = (String)this.value(prefix, params, "adapter", String.class, null);
            if (null == adapter) {
                return null;
            }
            if ((adapter = adapter.toLowerCase()).contains("Coze")) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                return this.inject(key, prefix, map, true);
            }
        }
        catch (Exception e) {
            log.error("\u6ce8\u518cCoze\u6570\u636e\u6e90 \u5f02\u5e38:", (Throwable)e);
        }
        return null;
    }

    public String inject(String key, Map params, boolean over) throws Exception {
        return this.inject(key, null, params, over);
    }

    public String inject(String key, String prefix, Map<String, Object> params, boolean override) throws Exception {
        String url;
        DataSourceHolder.check((String)key, (boolean)override);
        String datasource_id = "anyline.datasource." + key;
        HashMap cache = (HashMap)DataSourceHolder.params.get(key);
        if (null == cache) {
            cache = new HashMap();
            DataSourceHolder.params.put(key, cache);
        }
        if (BasicUtil.isEmpty((Object)(url = (String)this.value(prefix, params, "url,uri,host", String.class, null)))) {
            return null;
        }
        String adapter = (String)this.value(prefix, params, "adapter", String.class, null);
        if (null == adapter) {
            return null;
        }
        if (!(adapter = adapter.toLowerCase()).contains("Coze")) {
            return null;
        }
        String secret = (String)this.value(prefix, params, "secret,password,key", String.class, null);
        if (null == secret) {
            return null;
        }
        try {
            CozeClient client = new CozeClient(url, secret);
            CozeRuntimeHolder.instance().reg(key, client);
        }
        catch (Exception e) {
            log.error("[\u6ce8\u518c\u6570\u636e\u6e90\u5931\u8d25][type:Coze][key:{}][msg:{}]", (Object)key, (Object)e.toString());
            return null;
        }
        return datasource_id;
    }

    public String create(String key, String prefix) {
        return this.reg(key, prefix);
    }

    public boolean validate(String ds) {
        return this.validate(RuntimeHolder.runtime((String)ds));
    }

    public boolean validate() {
        return this.validate(RuntimeHolder.runtime());
    }

    public boolean validate(DataRuntime runtime) {
        CozeClient client = (CozeClient)runtime.getProcessor();
        return this.validate(client);
    }

    public boolean validate(CozeClient client) {
        try {
            return this.exeValidate(client);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean exeValidate(CozeClient client) {
        return true;
    }

    public String regTransactionManager(String key, DataSource datasource, boolean primary) {
        return "";
    }

    public String runtime(String key, String datasource, boolean override) throws Exception {
        return datasource;
    }

    public DataRuntime runtime(String key, Object datasource, String database, DatabaseType type, DriverAdapter adapter, boolean override) throws Exception {
        return null;
    }
}

