/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.coze.datasource;

import java.util.ArrayList;
import java.util.List;
import org.anyline.annotation.AnylineComponent;
import org.anyline.data.coze.datasource.CozeClient;
import org.anyline.data.coze.datasource.CozeDataSourceHolder;
import org.anyline.data.datasource.DataSourceHolder;
import org.anyline.data.datasource.DataSourceLoader;
import org.anyline.data.datasource.init.AbstractDataSourceLoader;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.util.DataSourceUtil;
import org.anyline.log.Log;
import org.anyline.log.LogProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.ConfigTable;

@AnylineComponent(value="anyline.environment.data.datasource.loader.Coze")
public class CozeDataSourceLoader
extends AbstractDataSourceLoader
implements DataSourceLoader {
    public static final Log log = LogProxy.get(CozeDataSourceLoader.class);
    private final CozeDataSourceHolder holder = CozeDataSourceHolder.instance();

    public DataSourceHolder holder() {
        return this.holder;
    }

    public List<String> load() {
        ArrayList<String> list = new ArrayList<String>();
        boolean loadDefault = true;
        if (!ConfigTable.environment().containsBean("anyline.datasource..default")) {
            DataRuntime runtime = null;
            CozeClient client = null;
            try {
                client = (CozeClient)ConfigTable.environment().getBean(CozeClient.class);
            }
            catch (Exception e) {
                runtime = null;
            }
            if (null != client) {
                try {
                    runtime = this.holder().create("Coze", (Object)client, false);
                    loadDefault = false;
                }
                catch (Exception e) {
                    runtime = null;
                    log.error("\u52a0\u8f7dCoze\u6570\u636e\u6e90 \u5f02\u5e38:", (Throwable)e);
                }
            }
            if (null != runtime) {
                String url = ConfigTable.environment().string("spring.datasource.,anyline.datasource.", "url,uri,host");
                runtime.setUrl(url);
                if (BasicUtil.isNotEmpty((Object)url)) {
                    runtime.setAdapterKey(DataSourceUtil.parseAdapterKey((String)url));
                } else {
                    String adapterKey = ConfigTable.environment().string("spring.datasource.,anyline.datasource.", "adapter");
                    if (BasicUtil.isNotEmpty((Object)adapterKey)) {
                        runtime.setAdapterKey(adapterKey);
                    }
                }
            }
        } else {
            loadDefault = false;
        }
        list.addAll(this.load("spring.datasource", loadDefault));
        list.addAll(this.load("anyline.datasource", loadDefault));
        return list;
    }
}

