/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.coze.adapter;

import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.annotation.AnylineComponent;
import org.anyline.data.adapter.DriverActuator;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.coze.adapter.CozeAdapter;
import org.anyline.data.coze.entity.Document;
import org.anyline.data.coze.run.CozeRun;
import org.anyline.data.coze.runtime.CozeRuntime;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.run.Run;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.DefaultPageNavi;
import org.anyline.entity.PageNavi;
import org.anyline.metadata.ACTION;
import org.anyline.metadata.Column;
import org.anyline.metadata.Metadata;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Table;
import org.anyline.net.HttpResponse;
import org.anyline.net.HttpUtil;
import org.anyline.util.BeanUtil;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;

@AnylineComponent(value="anyline.environment.data.driver.actuator.Coze")
public class CozeActuator
implements DriverActuator {
    public Class<? extends DriverAdapter> supportAdapterType() {
        return CozeAdapter.class;
    }

    public DataSource getDataSource(DriverAdapter adapter, DataRuntime runtime) {
        return null;
    }

    public Connection getConnection(DriverAdapter adapter, DataRuntime runtime, DataSource datasource) {
        return null;
    }

    public void releaseConnection(DriverAdapter adapter, DataRuntime runtime, Connection connection, DataSource datasource) {
    }

    public <T extends Metadata> void checkSchema(DriverAdapter adapter, DataRuntime runtime, DataSource datasource, T meta) {
    }

    public <T extends Metadata> void checkSchema(DriverAdapter adapter, DataRuntime runtime, T meta) {
    }

    public <T extends Metadata> void checkSchema(DriverAdapter adapter, DataRuntime runtime, Connection con, T meta) {
    }

    public String product(DriverAdapter adapter, DataRuntime runtime, boolean create, String product) {
        return null;
    }

    public String version(DriverAdapter adapter, DataRuntime runtime, boolean create, String version) {
        return null;
    }

    public DataSet<DataRow> select(DriverAdapter adapter, DataRuntime runtime, String random, boolean system, ACTION.DML action, Table table, ConfigStore configs, Run run, String cmd, List<Object> values, LinkedHashMap<String, Column> columns) throws Exception {
        DataSet set = new DataSet();
        long fr = System.currentTimeMillis();
        CozeRuntime r = (CozeRuntime)runtime;
        Map<String, String> headers = this.header(r);
        headers.put("Agw-Js-Conv", "str");
        String api = r.client().getHost() + "/open_api/knowledge/document/list";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dataset_id", table.getId());
        int pages = 1;
        int vol = 30;
        for (int page = 1; page <= pages; ++page) {
            params.put("page", 1);
            params.put("size", 30);
            HttpResponse response = HttpUtil.post(headers, (String)api, (String)"UTF-8", (HttpEntity)new StringEntity(BeanUtil.map2json(params), "UTF-8"));
            DataRow json = DataRow.parseJson((String)response.getText());
            DataSet infos = json.getSet("document_infos");
            for (DataRow info : infos) {
                Document document = new Document();
                set.add((DataRow)document);
                document.setId(info.getString("document_id"));
                document.setName(info.getString("document_name"));
                document.setUrl(info.getString("web_url"));
            }
            DefaultPageNavi navi = new DefaultPageNavi();
            navi.setPageRows(vol);
            navi.setTotalRow(json.getLong("total").longValue());
            set.setNavi((PageNavi)navi);
            pages = (int)navi.getTotalPage();
        }
        configs.setLastPackageTime(System.currentTimeMillis() - fr);
        return set;
    }

    public List<Map<String, Object>> maps(DriverAdapter adapter, DataRuntime runtime, String random, ConfigStore configs, Run run) throws Exception {
        return null;
    }

    public Map<String, Object> map(DriverAdapter adapter, DataRuntime runtime, String random, ConfigStore configs, Run run) throws Exception {
        return null;
    }

    public long insert(DriverAdapter adapter, DataRuntime runtime, String random, Object data, ConfigStore configs, Run run, String generatedKey, String[] pks) throws Exception {
        long cnt = 0L;
        CozeRun r = (CozeRun)run;
        CozeRuntime rt = (CozeRuntime)runtime;
        Map<String, String> headers = this.header(rt);
        String api = rt.client().getHost() + "/open_api/knowledge/document/create";
        Table table = run.getTable();
        headers.put("Agw-Js-Conv", "str");
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("dataset_id", table.getId());
        ArrayList docs = new ArrayList();
        List<Document> documents = r.getDocuments();
        cnt = documents.size();
        for (Document document : documents) {
            HashMap<String, Object> doc = new HashMap<String, Object>();
            doc.put("name", document.getName());
            HashMap<String, Object> source = new HashMap<String, Object>();
            source.put("web_url", document.getUrl());
            source.put("document_source", 1);
            doc.put("source_info", source);
            HashMap<String, Integer> rule = new HashMap<String, Integer>();
            rule.put("update_type", 1);
            rule.put("update_interval", 24);
            doc.put("update_rule", rule);
            docs.add(doc);
        }
        body.put("document_bases", docs);
        HashMap<String, Integer> chunk = new HashMap<String, Integer>();
        chunk.put("chunk_type", 0);
        body.put("chunk_strategy", chunk);
        body.put("format_type", 0);
        String json = BeanUtil.map2json(body);
        HttpResponse response = HttpUtil.post(headers, (String)api, (String)"UTF-8", (HttpEntity)new StringEntity(json, "UTF-8"));
        int status = response.getStatus();
        String text = response.getText();
        DataRow row = DataRow.parseJson((String)text);
        DataSet infos = row.getSet("document_infos");
        int i = 0;
        for (DataRow info : infos) {
            Document document = documents.get(i);
            document.setId(info.getString("document_id"));
            document.setName(info.getString("name"));
            ++i;
        }
        return cnt;
    }

    public long update(DriverAdapter adapter, DataRuntime runtime, String random, Table dest, Object data, ConfigStore configs, Run run) throws Exception {
        long cnt = 0L;
        CozeRun r = (CozeRun)run;
        CozeRuntime rt = (CozeRuntime)runtime;
        Map<String, String> headers = this.header(rt);
        List<Document> documents = r.getDocuments();
        headers.put("Agw-Js-Conv", "str");
        String api = rt.client().getHost() + "/open_api/knowledge/document/update";
        for (Document document : documents) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("document_id", document.getId());
            params.put("document_name", document.getName());
            HashMap<String, Integer> update_rule = new HashMap<String, Integer>();
            params.put("update_rule", update_rule);
            update_rule.put("update_type", 0);
            HttpResponse response = HttpUtil.post(headers, (String)api, (String)"UTF-8", (HttpEntity)new StringEntity(BeanUtil.map2json(params), "UTF-8"));
            ++cnt;
        }
        return cnt;
    }

    public long execute(DriverAdapter adapter, DataRuntime runtime, String random, ConfigStore configs, Run run) throws Exception {
        long count = 0L;
        ACTION action = run.action();
        CozeRun r = (CozeRun)run;
        CozeRuntime rt = (CozeRuntime)runtime;
        if (action == ACTION.DML.DELETE) {
            List<Document> documents = r.getDocuments();
            for (Document document : documents) {
                count += (long)this.delete(rt, r.getTable(), document);
            }
        } else if (action == ACTION.DDL.TABLE_CREATE) {
            Table table = r.getTable();
            this.create(rt, table);
            ++count;
        }
        return count;
    }

    public int delete(CozeRuntime runtime, Table table, Document document) throws Exception {
        CozeRuntime rt = runtime;
        Map<String, String> headers = this.header(rt);
        String api = rt.client().getHost() + "/open_api/knowledge/document/delete";
        headers.put("Agw-Js-Conv", "str");
        HashMap body = new HashMap();
        ArrayList<String> docs = new ArrayList<String>();
        docs.add(document.getId());
        body.put("document_ids", docs);
        String json = BeanUtil.map2json(body);
        HttpResponse response = HttpUtil.post(headers, (String)api, (String)"UTF-8", (HttpEntity)new StringEntity(json, "UTF-8"));
        return 1;
    }

    public DataRow upload(CozeRuntime runtime, String url, Document document, Map<String, Object> params) throws Exception {
        return null;
    }

    public Table create(CozeRuntime runtime, Table table) throws Exception {
        String name = table.getName();
        String api = runtime.client().getHost() + "/v1/datasets";
        Map<String, String> headers = this.header(runtime);
        HashMap<String, Object> body = new HashMap<String, Object>();
        Schema schema = table.getSchema();
        if (null != schema) {
            body.put("space_id", schema.getId());
        }
        body.put("name", name);
        body.put("format_type", 0);
        String json = BeanUtil.map2json(body);
        HttpResponse response = HttpUtil.post(headers, (String)api, (String)"UTF-8", (HttpEntity)new StringEntity(json, "UTF-8"));
        int status = response.getStatus();
        if (status != 200) {
            throw new Exception("\u521b\u5efa\u77e5\u8bc6\u5e93http\u72b6\u6001\u5f02\u5e38:" + status);
        }
        String text = response.getText();
        DataRow row = DataRow.parseJson((String)text);
        int code = row.getInt("code");
        if (code != 0) {
            throw new Exception(row.getString("msg"));
        }
        table.setId(row.getRow("data").getString("dataset_id"));
        table.setName(name);
        return table;
    }

    public <T extends Table> List<T> tables(DriverAdapter adapter, DataRuntime runtime, boolean create, List<T> previous, Table query, int types) throws Exception {
        if (null == previous) {
            previous = new ArrayList<T>();
        }
        CozeRuntime rt = (CozeRuntime)runtime;
        Map<String, String> headers = this.header(rt);
        String api = rt.client().getHost() + "/v1/datasets";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", query.getName());
        try {
            HttpResponse response = HttpUtil.get(headers, (String)api, (String)"UTF-8", params);
            int status = response.getStatus();
            String text = response.getText();
            DataRow row = DataRow.parseJson((String)text);
            DataSet set = row.getRow("data").getSet("dataset_list");
            for (DataRow item : set) {
                Table table = new Table();
                previous.add(table);
                table.setId(item.getString("dataset_id"));
                table.setName(item.getString("name"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return previous;
    }

    public DataRow post(CozeRuntime runtime, String url, Map<String, Object> params) throws Exception {
        url = HttpUtil.mergePath((String[])new String[]{runtime.client().getHost(), url});
        Map<String, String> header = this.header(runtime);
        String json = BeanUtil.map2json(params);
        HttpResponse response = HttpUtil.post(header, (String)url, (String)"UTF-8", (HttpEntity)new StringEntity(json, "UTF-8"));
        int status = response.getStatus();
        String body = response.getText();
        return DataRow.parse((Object)body, (String[])new String[0]);
    }

    public void post(CozeRuntime runtime, String url, Map<String, Object> params, File file) {
        Map<String, String> header = this.header(runtime);
        String json = BeanUtil.map2json(params);
        params = new HashMap<String, Object>();
        params.put("data", json);
        HashMap<String, File> files = new HashMap<String, File>();
        files.put("file", file);
        HttpUtil.upload((String)url, files, (String)"UTF-8", header, params);
    }

    public DataRow get(CozeRuntime runtime, String url, Map<String, Object> params) throws Exception {
        url = HttpUtil.mergePath((String[])new String[]{runtime.client().getHost(), url});
        Map<String, String> header = this.header(runtime);
        HttpResponse response = HttpUtil.get(header, (String)url, (String)"UTF-8", params);
        int status = response.getStatus();
        String body = response.getText();
        return DataRow.parse((Object)body, (String[])new String[0]);
    }

    protected Map<String, String> header(CozeRuntime runtime) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", "Bearer " + runtime.getSecret());
        header.put("Content-Type", "application/json");
        return header;
    }
}

