/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.dify.adapter;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.annotation.AnylineComponent;
import org.anyline.data.adapter.DriverActuator;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.dify.adapter.DifyAdapter;
import org.anyline.data.dify.entity.Document;
import org.anyline.data.dify.entity.Metadata;
import org.anyline.data.dify.run.DifyRun;
import org.anyline.data.dify.runtime.DifyRuntime;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.run.Run;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.DefaultPageNavi;
import org.anyline.entity.OriginRow;
import org.anyline.entity.PageNavi;
import org.anyline.metadata.ACTION;
import org.anyline.metadata.Column;
import org.anyline.metadata.Embedding;
import org.anyline.metadata.Table;
import org.anyline.net.HttpResponse;
import org.anyline.net.HttpUtil;
import org.anyline.util.BeanUtil;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

@AnylineComponent(value="anyline.environment.data.driver.actuator.dify")
public class DifyActuator
implements DriverActuator {
    public Class<? extends DriverAdapter> supportAdapterType() {
        return DifyAdapter.class;
    }

    public DataSource getDataSource(DriverAdapter adapter, DataRuntime runtime) {
        return null;
    }

    public Connection getConnection(DriverAdapter adapter, DataRuntime runtime, DataSource datasource) {
        return null;
    }

    public void releaseConnection(DriverAdapter adapter, DataRuntime runtime, Connection connection, DataSource datasource) {
    }

    public <T extends org.anyline.metadata.Metadata> void checkSchema(DriverAdapter adapter, DataRuntime runtime, DataSource datasource, T meta) {
    }

    public <T extends org.anyline.metadata.Metadata> void checkSchema(DriverAdapter adapter, DataRuntime runtime, T meta) {
    }

    public <T extends org.anyline.metadata.Metadata> void checkSchema(DriverAdapter adapter, DataRuntime runtime, Connection con, T meta) {
    }

    public String product(DriverAdapter adapter, DataRuntime runtime, boolean create, String product) {
        return null;
    }

    public String version(DriverAdapter adapter, DataRuntime runtime, boolean create, String version) {
        return null;
    }

    public DataSet<DataRow> select(DriverAdapter adapter, DataRuntime runtime, String random, boolean system, ACTION.DML action, Table table, ConfigStore configs, Run run, String cmd, List<Object> values, LinkedHashMap<String, Column> columns) throws Exception {
        DataSet set = new DataSet();
        long fr = System.currentTimeMillis();
        DifyRun r = (DifyRun)run;
        String url = "/datasets/" + table.getId() + "/documents";
        Map<String, Object> params = r.getQueryParams();
        DataRow row = this.get((DifyRuntime)runtime, url, params);
        configs.setLastExecuteTime(System.currentTimeMillis() - fr);
        fr = System.currentTimeMillis();
        PageNavi navi = r.getNavi();
        if (null == navi) {
            navi = new DefaultPageNavi();
        }
        set.setNavi(navi);
        if (null != row) {
            int total = row.getInt("total", Integer.valueOf(0));
            navi.setTotalRow((long)total);
            navi.setPageRows(row.getInt("limit", Integer.valueOf(20)).intValue());
            DataSet datas = row.getSet("data");
            if (null != datas) {
                for (DataRow data : datas) {
                    Document doc = new Document();
                    doc.setId(data.getString("id"));
                    doc.setName(data.getString("name"));
                    doc.setPosition(data.getInt("position", Integer.valueOf(0)));
                    doc.setError(data.getString("error"));
                    doc.setCreated_from(data.getString("created_from"));
                    doc.setCreateTime(data.getLong("created_at"));
                    doc.setToken_count(data.getInt("tokens", Integer.valueOf(0)));
                    doc.setIndexing_status(data.getString("indexing_status"));
                    doc.setWord_count(data.getInt("word_count", Integer.valueOf(0)));
                    doc.setHit_count(data.getInt("hit_count", Integer.valueOf(0)));
                    doc.setEnabled(data.getBoolean("enabled", Boolean.valueOf(false)));
                    set.add((DataRow)doc);
                }
            }
        }
        configs.setLastPackageTime(System.currentTimeMillis() - fr);
        return set;
    }

    public List<Map<String, Object>> maps(DriverAdapter adapter, DataRuntime runtime, String random, ConfigStore configs, Run run) throws Exception {
        return null;
    }

    public Map<String, Object> map(DriverAdapter adapter, DataRuntime runtime, String random, ConfigStore configs, Run run) throws Exception {
        return null;
    }

    public long insert(DriverAdapter adapter, DataRuntime runtime, String random, Object data, ConfigStore configs, Run run, String generatedKey, String[] pks) throws Exception {
        long cnt = 0L;
        DifyRuntime rt = (DifyRuntime)runtime;
        DifyRun r = (DifyRun)run;
        Table table = r.getTable();
        List<Document> documents = r.getDocuments();
        for (Document document : documents) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("indexing_technique", "high_quality");
            HashMap<String, String> rule = new HashMap<String, String>();
            rule.put("mode", "automatic");
            params.put("process_rule", rule);
            File file = document.getFile();
            DataRow row = null;
            if (null != file) {
                url = "/datasets/" + table.getId() + "/document/create-by-file";
                row = this.upload(rt, url, document, params);
            } else {
                params.put("name", document.getName());
                url = "/datasets/" + table.getId() + "/document/create-by-text";
                params.put("text", document.getText());
                row = this.post(rt, url, params);
            }
            DataRow doc = row.getRow("DOCUMENT");
            if (null != doc) {
                document.setId(doc.getString("ID"));
            }
            this.setMetadata(rt, table, document);
        }
        return cnt;
    }

    public long update(DriverAdapter adapter, DataRuntime runtime, String random, Table dest, Object data, ConfigStore configs, Run run) throws Exception {
        long cnt = 0L;
        return cnt;
    }

    public long execute(DriverAdapter adapter, DataRuntime runtime, String random, ConfigStore configs, Run run) throws Exception {
        long count = 0L;
        ACTION action = run.action();
        DifyRun r = (DifyRun)run;
        DifyRuntime rt = (DifyRuntime)runtime;
        List<Document> documents = r.getDocuments();
        if (action == ACTION.DML.DELETE) {
            for (Document document : documents) {
                count += (long)this.delete(rt, r.getTable(), document);
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(DifyRuntime runtime, Table table, Document document) throws Exception {
        Object url = "/datasets/" + table.getId() + "/documents/" + document.getId();
        url = HttpUtil.mergePath((String[])new String[]{runtime.client().getHost(), url});
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpDelete delete = new HttpDelete((String)url);
        delete.setHeader("Authorization", "Bearer " + runtime.client().getSecret());
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)delete);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                int n = 0;
                return n;
            }
            String string = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (Exception e) {
            e.printStackTrace();
            int n = 0;
            return n;
        }
        finally {
            try {
                httpClient.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataRow upload(DifyRuntime runtime, String url, Document document, Map<String, Object> params) throws Exception {
        url = HttpUtil.mergePath((String[])new String[]{runtime.client().getHost(), url});
        RequestConfig config = RequestConfig.custom().build();
        try (CloseableHttpClient client = HttpClients.custom().setDefaultRequestConfig(config).build();){
            DataRow row;
            HttpPost post = new HttpPost(url);
            post.setHeader("Authorization", "Bearer " + runtime.client().getSecret());
            MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.RFC6532);
            String jsonData = BeanUtil.map2json(params);
            builder.addTextBody("data", jsonData, ContentType.TEXT_PLAIN);
            builder.addBinaryBody("file", document.getFile(), ContentType.APPLICATION_OCTET_STREAM, document.getFile().getName());
            HttpEntity entity = builder.build();
            post.setEntity(entity);
            String body = (String)client.execute((HttpUriRequest)post, response -> {
                int statusCode = response.getStatusLine().getStatusCode();
                String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                if (statusCode >= 200 && statusCode < 300) {
                    return responseBody;
                }
                throw new IOException("\u4e0a\u4f20\u5931\u8d25\uff0c\u72b6\u6001\u7801: " + statusCode + "\u54cd\u5e94\u5185\u5bb9: " + responseBody);
            });
            DataRow dataRow = row = DataRow.parseJson((String)body);
            return dataRow;
        }
    }

    public void addMetadata(DifyRuntime runtime, Table table, Metadata metadata) throws Exception {
        String url = "/datasets/" + table.getId() + "/metadata";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", metadata.getType());
        params.put("name", metadata.getName());
        DataRow row = this.post(runtime, url, params);
        metadata.setId(row.getString("ID"));
    }

    public boolean setMetadata(DifyRuntime runtime, Table table, List<Document> documents) {
        Object url = "/datasets/" + table.getId() + "/documents/metadata";
        OriginRow body = new OriginRow();
        DataSet datas = body.puts("operation_data");
        boolean empty = true;
        for (Document document : documents) {
            DataRow data = datas.add();
            data.put("document_id", (Object)document.getId());
            LinkedHashMap metadatas = document.getMetadatas();
            DataSet metas = data.puts("metadata_list");
            for (Column metadata : metadatas.values()) {
                metas.add(((Metadata)metadata).map());
                empty = false;
            }
        }
        if (!empty) {
            String json = BeanUtil.map2json((Map)body);
            url = HttpUtil.mergePath((String[])new String[]{runtime.client().getHost(), url});
            Map<String, String> header = this.header(runtime);
            HttpResponse response = HttpUtil.post(header, (String)url, (String)"UTF-8", (HttpEntity)new StringEntity(json, "UTF-8"));
            int status = response.getStatus();
            String txt = response.getText();
            if (status == 200) {
                return false;
            }
            DataRow row = DataRow.parseJson((String)txt);
            if (null == row) {
                return false;
            }
            return row.getBoolean("success", Boolean.valueOf(false));
        }
        return false;
    }

    public boolean setMetadata(DifyRuntime runtime, Table table, Document document) {
        ArrayList<Document> documents = new ArrayList<Document>();
        documents.add(document);
        return this.setMetadata(runtime, table, documents);
    }

    public <T extends Table> List<T> tables(DriverAdapter adapter, DataRuntime runtime, boolean create, List<T> previous, Table query, int types) throws Exception {
        String url;
        DataRow row;
        DataSet set;
        if (null == previous) {
            previous = new ArrayList<T>();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (null != query) {
            params.put("keyword", query.getName());
        }
        if (null != (set = (row = this.get((DifyRuntime)runtime, url = "/datasets", params)).getSet("data"))) {
            for (DataRow item : set) {
                Table table = new Table();
                String name = item.getString("name");
                table.setName(name);
                table.setId(item.getString("id"));
                table.setProvider(item.getString("PROVIDER"));
                table.setEmbedding(new Embedding(item.getString("EMBEDDING_MODEL"), item.getString("EMBEDDING_MODEL_PROVIDER")));
                DataSet metas = item.getSet("DOC_METADATA");
                for (DataRow meta : metas) {
                    Metadata metadata = new Metadata();
                    metadata.setType(meta.getString("TYPE"));
                    metadata.setName(meta.getString("NAME"));
                    metadata.setId(meta.getString("ID"));
                    table.addColumn((Column)metadata);
                }
                previous.add(table);
            }
        }
        return previous;
    }

    public DataRow post(DifyRuntime runtime, String url, Map<String, Object> params) throws Exception {
        url = HttpUtil.mergePath((String[])new String[]{runtime.client().getHost(), url});
        Map<String, String> header = this.header(runtime);
        String json = BeanUtil.map2json(params);
        HttpResponse response = HttpUtil.post(header, (String)url, (String)"UTF-8", (HttpEntity)new StringEntity(json, "UTF-8"));
        int status = response.getStatus();
        String body = response.getText();
        return DataRow.parse((Object)body, (String[])new String[0]);
    }

    public void post(DifyRuntime runtime, String url, Map<String, Object> params, File file) {
        Map<String, String> header = this.header(runtime);
        String json = BeanUtil.map2json(params);
        params = new HashMap<String, Object>();
        params.put("data", json);
        HashMap<String, File> files = new HashMap<String, File>();
        files.put("file", file);
        HttpUtil.upload((String)url, files, (String)"UTF-8", header, params);
    }

    public DataRow get(DifyRuntime runtime, String url, Map<String, Object> params) throws Exception {
        url = HttpUtil.mergePath((String[])new String[]{runtime.client().getHost(), url});
        Map<String, String> header = this.header(runtime);
        HttpResponse response = HttpUtil.get(header, (String)url, (String)"UTF-8", params);
        int status = response.getStatus();
        String body = response.getText();
        return DataRow.parse((Object)body, (String[])new String[0]);
    }

    protected Map<String, String> header(DifyRuntime runtime) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        header.put("Accept", "application/json");
        DifyRuntime r = runtime;
        header.put("Authorization", "Bearer " + r.getSecret());
        return header;
    }
}

