/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.dify.runtime;

import java.util.Map;
import org.anyline.bean.BeanDefine;
import org.anyline.bean.init.DefaultBeanDefine;
import org.anyline.dao.init.DefaultDao;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.dify.adapter.DifyAdapter;
import org.anyline.data.dify.datasource.DifyClient;
import org.anyline.data.dify.runtime.DifyRuntime;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.runtime.RuntimeHolder;
import org.anyline.data.runtime.init.AbstractRuntimeHolder;
import org.anyline.service.init.DefaultService;
import org.anyline.util.ConfigTable;

public class DifyRuntimeHolder
extends AbstractRuntimeHolder {
    private static final DifyRuntimeHolder instance = new DifyRuntimeHolder();

    public static DifyRuntimeHolder instance() {
        return instance;
    }

    public DataRuntime temporary(Object client, String database, DriverAdapter adapter) throws Exception {
        DifyRuntime runtime = new DifyRuntime();
        if (null == adapter) {
            adapter = (DriverAdapter)ConfigTable.environment().getBean(DifyAdapter.class);
        }
        if (!(client instanceof DifyClient)) {
            throw new Exception("\u8bf7\u63d0\u4f9bDifyClient\u517c\u5bb9\u7c7b\u578b");
        }
        String key = "temporary_dify";
        temporary.remove(key);
        runtime.setKey(key);
        runtime.setAdapter(adapter);
        runtime.setProcessor(client);
        temporary.put(key, (DifyClient)client);
        log.warn("[\u521b\u5efa\u4e34\u65f6\u6570\u636e\u6e90][key:{}][type:{}]", (Object)key, (Object)client.getClass().getSimpleName());
        return runtime;
    }

    public DataRuntime reg(String key, DifyClient client) throws Exception {
        String datasource_key = "anyline.datasource." + key;
        log.info("[\u6ce8\u5165\u6570\u636e\u6e90][type:dify][key:{}][bean:{}]", (Object)key, (Object)datasource_key);
        ConfigTable.environment().regBean(datasource_key, (Object)client);
        return this.reg(key, client, null);
    }

    public DifyRuntime reg(String datasource, DifyClient client, DriverAdapter adapter) throws Exception {
        log.debug("[create dify runtime][key:{}]", (Object)datasource);
        if (null == adapter) {
            adapter = (DriverAdapter)ConfigTable.environment().getBean(DifyAdapter.class);
        }
        DifyRuntime runtime = new DifyRuntime(datasource, client, adapter);
        if (runtimes.containsKey(datasource)) {
            this.destroy(datasource);
        }
        runtimes.put(datasource, runtime);
        String dao_key = "anyline.dao." + datasource;
        String service_key = "anyline.service." + datasource;
        log.info("[instance service][data source:{}][instance id:{}]", (Object)datasource, (Object)service_key);
        DefaultBeanDefine daoDefine = new DefaultBeanDefine(DefaultDao.class);
        daoDefine.addValue("runtime", (Object)runtime);
        ConfigTable.environment().regBean(dao_key, (BeanDefine)daoDefine);
        DefaultBeanDefine serviceDefine = new DefaultBeanDefine(DefaultService.class);
        serviceDefine.addReferenceValue("dao", dao_key);
        ConfigTable.environment().regBean(service_key, (BeanDefine)serviceDefine);
        return runtime;
    }

    public boolean destroy(String key) {
        try {
            runtimes.remove(key);
            ConfigTable.environment().destroyBean("anyline.service." + key);
            ConfigTable.environment().destroyBean("anyline.dao." + key);
            ConfigTable.environment().destroyBean("anyline.transaction." + key);
            ConfigTable.environment().destroyBean("anyline.datasource." + key);
            log.warn("[\u6ce8\u9500\u6570\u636e\u6e90\u53ca\u76f8\u5173\u8d44\u6e90][key:{}]", (Object)key);
            Map runtimes = RuntimeHolder.runtimes((String)key);
            for (String item : runtimes.keySet()) {
                this.destroy(item);
            }
        }
        catch (Exception e) {
            log.error("\u6ce8\u9500\u6570\u636e\u6e90 \u5f02\u5e38:", (Throwable)e);
            return false;
        }
        return true;
    }
}

