/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cache;

import java.lang.reflect.Method;
import java.util.Map;
import org.aoju.bus.cache.CacheConfig;
import org.aoju.bus.cache.CacheCore;
import org.aoju.bus.cache.CacheModule;
import org.aoju.bus.cache.annotation.Cached;
import org.aoju.bus.cache.annotation.CachedGet;
import org.aoju.bus.cache.annotation.Invalid;
import org.aoju.bus.cache.invoker.InvocationBaseInvoker;
import org.aoju.bus.cache.support.cache.Cache;
import org.apache.commons.proxy.Interceptor;
import org.apache.commons.proxy.Invocation;
import org.apache.commons.proxy.ProxyFactory;
import org.apache.commons.proxy.factory.cglib.CglibProxyFactory;
import org.springframework.beans.factory.FactoryBean;

public class CacheProxy<T>
implements FactoryBean<T> {
    private Object target;
    private Object proxy;
    private Class<T> type;
    private CacheConfig.Switch cglib = CacheConfig.Switch.OFF;
    private CacheCore cacheCore;
    private Interceptor interceptor = new Interceptor(){

        public Object intercept(Invocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            Cached cached = method.getAnnotation(Cached.class);
            if (cached != null) {
                return CacheProxy.this.cacheCore.readWrite(cached, method, new InvocationBaseInvoker(CacheProxy.this.target, invocation));
            }
            CachedGet cachedGet = method.getAnnotation(CachedGet.class);
            if (cachedGet != null) {
                return CacheProxy.this.cacheCore.read(cachedGet, method, new InvocationBaseInvoker(CacheProxy.this.target, invocation));
            }
            Invalid invalid = method.getAnnotation(Invalid.class);
            if (invalid != null) {
                CacheProxy.this.cacheCore.remove(invalid, method, invocation.getArguments());
                return null;
            }
            return invocation.proceed();
        }
    };

    public CacheProxy(Object target, Map<String, Cache> caches) {
        this(target, target.getClass().getInterfaces()[0], caches, CacheConfig.Switch.OFF);
    }

    public CacheProxy(Object target, Class<T> type, Map<String, Cache> caches, CacheConfig.Switch cglib) {
        this.target = target;
        this.type = type;
        this.cglib = cglib;
        this.proxy = this.newProxy();
        this.cacheCore = CacheModule.coreInstance(CacheConfig.newConfig(caches));
    }

    private Object newProxy() {
        Object factory = this.cglib == CacheConfig.Switch.ON || !this.type.isInterface() ? new CglibProxyFactory() : new ProxyFactory();
        return factory.createInterceptorProxy(this.target, this.interceptor, new Class[]{this.type});
    }

    public T getObject() {
        return (T)this.proxy;
    }

    public Class<T> getObjectType() {
        return this.type;
    }

    public boolean isSingleton() {
        return true;
    }
}

