/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.asymmetric;

import java.io.InputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.consts.Charset;
import org.aoju.bus.core.utils.HexUtils;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.crypto.CryptoUtils;
import org.aoju.bus.crypto.KeyType;
import org.aoju.bus.crypto.asymmetric.BaseAsymmetric;

public abstract class AbstractAsymmetric<T extends AbstractAsymmetric<T>>
extends BaseAsymmetric<T> {
    public AbstractAsymmetric(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        super(algorithm, privateKey, publicKey);
    }

    public static byte[] strToBcd(String asc) {
        int len = asc.length();
        int mod = len % 2;
        if (mod != 0) {
            asc = "0" + asc;
            len = asc.length();
        }
        byte[] abt = new byte[len];
        if (len >= 2) {
            len >>= 1;
        }
        byte[] bbt = new byte[len];
        abt = asc.getBytes();
        for (int p = 0; p < asc.length() / 2; ++p) {
            byte b;
            int j = abt[2 * p] >= 48 && abt[2 * p] <= 57 ? abt[2 * p] - 48 : (abt[2 * p] >= 97 && abt[2 * p] <= 122 ? abt[2 * p] - 97 + 10 : abt[2 * p] - 65 + 10);
            int k = abt[2 * p + 1] >= 48 && abt[2 * p + 1] <= 57 ? abt[2 * p + 1] - 48 : (abt[2 * p + 1] >= 97 && abt[2 * p + 1] <= 122 ? abt[2 * p + 1] - 97 + 10 : abt[2 * p + 1] - 65 + 10);
            int a = (j << 4) + k;
            bbt[p] = b = (byte)a;
        }
        return bbt;
    }

    public static byte[] ascToBcd(byte[] ascii) {
        return AbstractAsymmetric.ascToBcd(ascii, ascii.length);
    }

    public static byte[] ascToBcd(byte[] ascii, int ascLength) {
        byte[] bcd = new byte[ascLength / 2];
        int j = 0;
        for (int i = 0; i < (ascLength + 1) / 2; ++i) {
            bcd[i] = AbstractAsymmetric.ascToBcd(ascii[j++]);
            bcd[i] = (byte)((j >= ascLength ? (byte)0 : AbstractAsymmetric.ascToBcd(ascii[j++])) + (bcd[i] << 4));
        }
        return bcd;
    }

    public static String bcdToStr(byte[] bytes) {
        char[] temp = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            char val = (char)((bytes[i] & 0xF0) >> 4 & 0xF);
            temp[i * 2] = (char)(val > '\t' ? val + 65 - 10 : val + 48);
            val = (char)(bytes[i] & 0xF);
            temp[i * 2 + 1] = (char)(val > '\t' ? val + 65 - 10 : val + 48);
        }
        return new String(temp);
    }

    private static byte ascToBcd(byte asc) {
        byte bcd = asc >= 48 && asc <= 57 ? (byte)(asc - 48) : (asc >= 65 && asc <= 70 ? (byte)(asc - 65 + 10) : (asc >= 97 && asc <= 102 ? (byte)(asc - 97 + 10) : (byte)(asc - 48)));
        return bcd;
    }

    public abstract byte[] encrypt(byte[] var1, KeyType var2);

    public String encryptHex(byte[] data, KeyType keyType) {
        return HexUtils.encodeHexStr(this.encrypt(data, keyType));
    }

    public String encryptBase64(byte[] data, KeyType keyType) {
        return Base64.encode(this.encrypt(data, keyType));
    }

    public byte[] encrypt(String data, String charset, KeyType keyType) {
        return this.encrypt(StringUtils.bytes((CharSequence)data, charset), keyType);
    }

    public byte[] encrypt(String data, java.nio.charset.Charset charset, KeyType keyType) {
        return this.encrypt(StringUtils.bytes((CharSequence)data, charset), keyType);
    }

    public byte[] encrypt(String data, KeyType keyType) {
        return this.encrypt(StringUtils.bytes((CharSequence)data, Charset.UTF_8), keyType);
    }

    public String encryptHex(String data, KeyType keyType) {
        return HexUtils.encodeHexStr(this.encrypt(data, keyType));
    }

    public String encryptHex(String data, java.nio.charset.Charset charset, KeyType keyType) {
        return HexUtils.encodeHexStr(this.encrypt(data, charset, keyType));
    }

    public String encryptBase64(String data, KeyType keyType) {
        return Base64.encode(this.encrypt(data, keyType));
    }

    public String encryptBase64(String data, java.nio.charset.Charset charset, KeyType keyType) {
        return Base64.encode(this.encrypt(data, charset, keyType));
    }

    public byte[] encrypt(InputStream data, KeyType keyType) {
        return this.encrypt(IoUtils.readBytes(data), keyType);
    }

    public String encryptHex(InputStream data, KeyType keyType) {
        return HexUtils.encodeHexStr(this.encrypt(data, keyType));
    }

    public String encryptBase64(InputStream data, KeyType keyType) {
        return Base64.encode(this.encrypt(data, keyType));
    }

    public String encryptBcd(String data, KeyType keyType) {
        return this.encryptBcd(data, keyType, Charset.UTF_8);
    }

    public String encryptBcd(String data, KeyType keyType, java.nio.charset.Charset charset) {
        return AbstractAsymmetric.bcdToStr(this.encrypt(data, charset, keyType));
    }

    public abstract byte[] decrypt(byte[] var1, KeyType var2);

    public byte[] decrypt(InputStream data, KeyType keyType) {
        return this.decrypt(IoUtils.readBytes(data), keyType);
    }

    public byte[] decrypt(String data, KeyType keyType) {
        return this.decrypt(CryptoUtils.decode(data), keyType);
    }

    public String decryptStr(String data, KeyType keyType, java.nio.charset.Charset charset) {
        return StringUtils.str(this.decrypt(data, keyType), charset);
    }

    public String decryptStr(String data, KeyType keyType) {
        return this.decryptStr(data, keyType, Charset.UTF_8);
    }

    public byte[] decryptFromBcd(String data, KeyType keyType) {
        return this.decryptFromBcd(data, keyType, Charset.UTF_8);
    }

    public byte[] decryptFromBcd(String data, KeyType keyType, java.nio.charset.Charset charset) {
        byte[] dataBytes = AbstractAsymmetric.ascToBcd(StringUtils.bytes((CharSequence)data, charset));
        return this.decrypt(dataBytes, keyType);
    }

    public String decryptStrFromBcd(String data, KeyType keyType, java.nio.charset.Charset charset) {
        return StringUtils.str(this.decryptFromBcd(data, keyType, charset), charset);
    }

    public String decryptStrFromBcd(String data, KeyType keyType) {
        return this.decryptStrFromBcd(data, keyType, Charset.UTF_8);
    }
}

