/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.symmetric;

import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.crypto.CryptoUtils;
import org.aoju.bus.crypto.Mode;
import org.aoju.bus.crypto.Padding;
import org.aoju.bus.crypto.symmetric.Symmetric;

public class DES
extends Symmetric {
    public DES() {
        super(Mode.DES);
    }

    public DES(byte[] key) {
        super(Mode.DES, key);
    }

    public DES(Mode mode, Padding padding) {
        this(mode.name(), padding.name());
    }

    public DES(Mode mode, Padding padding, byte[] key) {
        this(mode, padding, key, null);
    }

    public DES(Mode mode, Padding padding, byte[] key, byte[] iv) {
        this(mode.name(), padding.name(), key, iv);
    }

    public DES(Mode mode, Padding padding, SecretKey key) {
        this(mode, padding, key, null);
    }

    public DES(Mode mode, Padding padding, SecretKey key, IvParameterSpec iv) {
        this(mode.name(), padding.name(), key, iv);
    }

    public DES(String mode, String padding) {
        this(mode, padding, (byte[])null);
    }

    public DES(String mode, String padding, byte[] key) {
        this(mode, padding, CryptoUtils.generateKey("DES", key), null);
    }

    public DES(String mode, String padding, byte[] key, byte[] iv) {
        this(mode, padding, CryptoUtils.generateKey("DES", key), null == iv ? null : new IvParameterSpec(iv));
    }

    public DES(String mode, String padding, SecretKey key) {
        this(mode, padding, key, null);
    }

    public DES(String mode, String padding, SecretKey key, IvParameterSpec iv) {
        super(StringUtils.format("DES/{}/{}", mode, padding), key, iv);
    }

    public DES setIv(IvParameterSpec iv) {
        super.setParams(iv);
        return this;
    }

    public DES setIv(byte[] iv) {
        this.setIv(new IvParameterSpec(iv));
        return this;
    }
}

