/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health;

import org.aoju.bus.core.utils.FileUtils;
import org.aoju.bus.health.SystemUtils;

public class RuntimeInfo {
    private Runtime currentRuntime = Runtime.getRuntime();

    public final Runtime getRuntime() {
        return this.currentRuntime;
    }

    public final long getMaxMemory() {
        return this.currentRuntime.maxMemory();
    }

    public final long getTotalMemory() {
        return this.currentRuntime.totalMemory();
    }

    public final long getFreeMemory() {
        return this.currentRuntime.freeMemory();
    }

    public final long getUsableMemory() {
        return this.currentRuntime.maxMemory() - this.currentRuntime.totalMemory() + this.currentRuntime.freeMemory();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        SystemUtils.append(builder, "Max Memory:    ", FileUtils.readableFileSize(this.getMaxMemory()));
        SystemUtils.append(builder, "Total Memory:     ", FileUtils.readableFileSize(this.getTotalMemory()));
        SystemUtils.append(builder, "Free Memory:     ", FileUtils.readableFileSize(this.getFreeMemory()));
        SystemUtils.append(builder, "Usable Memory:     ", FileUtils.readableFileSize(this.getUsableMemory()));
        return builder.toString();
    }
}

