/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.logger;

import java.io.Serializable;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.logger.Log;
import org.aoju.bus.logger.level.Level;

public abstract class AbstractLog
implements Log,
Serializable {
    private static final long serialVersionUID = -3211115409504005616L;

    public static String getSimpleMessage(Throwable e) {
        return null == e ? "null" : e.getMessage();
    }

    @Override
    public boolean isEnabled(Level level) {
        switch (level) {
            case TRACE: {
                return this.isTraceEnabled();
            }
            case DEBUG: {
                return this.isDebugEnabled();
            }
            case INFO: {
                return this.isInfoEnabled();
            }
            case WARN: {
                return this.isWarnEnabled();
            }
            case ERROR: {
                return this.isErrorEnabled();
            }
        }
        throw new Error(StringUtils.format("Can not identify level: {}", new Object[]{level}));
    }

    @Override
    public void trace(Throwable t) {
        this.trace(t, AbstractLog.getSimpleMessage(t), new Object[0]);
    }

    @Override
    public void debug(Throwable t) {
        this.debug(t, AbstractLog.getSimpleMessage(t), new Object[0]);
    }

    @Override
    public void info(Throwable t) {
        this.info(t, AbstractLog.getSimpleMessage(t), new Object[0]);
    }

    @Override
    public void warn(Throwable t) {
        this.warn(t, AbstractLog.getSimpleMessage(t), new Object[0]);
    }

    @Override
    public void error(Throwable t) {
        this.error(t, AbstractLog.getSimpleMessage(t), new Object[0]);
    }
}

