/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.logger;

import org.aoju.bus.core.utils.CallerUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.logger.LocationAware;
import org.aoju.bus.logger.Log;
import org.aoju.bus.logger.LogFactory;
import org.aoju.bus.logger.level.Level;

public final class Logger {
    private static final String FQCN = Logger.class.getName();

    private Logger() {
    }

    public static void trace(String format, Object ... arguments) {
        Logger.trace(LogFactory.get(CallerUtils.getCallers()), format, arguments);
    }

    public static void trace(Log log, String format, Object ... arguments) {
        if (!Logger.log(log, Level.TRACE, null, format, arguments)) {
            log.trace(format, arguments);
        }
    }

    public static void debug(String format, Object ... arguments) {
        Logger.debug(LogFactory.get(CallerUtils.getCallers()), format, arguments);
    }

    public static void debug(Log log, String format, Object ... arguments) {
        if (!Logger.log(log, Level.DEBUG, null, format, arguments)) {
            log.debug(format, arguments);
        }
    }

    public static void info(String format, Object ... arguments) {
        Logger.info(LogFactory.get(CallerUtils.getCallers()), format, arguments);
    }

    public static void info(Log log, String format, Object ... arguments) {
        if (!Logger.log(log, Level.INFO, null, format, arguments)) {
            log.info(format, arguments);
        }
    }

    public static void warn(String format, Object ... arguments) {
        Logger.warn(LogFactory.get(CallerUtils.getCallers()), format, arguments);
    }

    public static void warn(Throwable e, String format, Object ... arguments) {
        Logger.warn(LogFactory.get(CallerUtils.getCallers()), e, StringUtils.format(format, arguments), new Object[0]);
    }

    public static void warn(Log log, String format, Object ... arguments) {
        Logger.warn(log, null, format, arguments);
    }

    public static void warn(Log log, Throwable e, String format, Object ... arguments) {
        if (!Logger.log(log, Level.WARN, e, format, arguments)) {
            log.warn(e, format, arguments);
        }
    }

    public static void error(Throwable e) {
        Logger.error(LogFactory.get(CallerUtils.getCallers()), e);
    }

    public static void error(String format, Object ... arguments) {
        Logger.error(LogFactory.get(CallerUtils.getCallers()), format, arguments);
    }

    public static void error(Throwable e, String format, Object ... arguments) {
        Logger.error(LogFactory.get(CallerUtils.getCallers()), e, format, arguments);
    }

    public static void error(Log log, Throwable e) {
        Logger.error(log, e, e.getMessage(), new Object[0]);
    }

    public static void error(Log log, String format, Object ... arguments) {
        Logger.error(log, null, format, arguments);
    }

    public static void error(Log log, Throwable e, String format, Object ... arguments) {
        if (!Logger.log(log, Level.ERROR, e, format, arguments)) {
            log.error(e, format, arguments);
        }
    }

    public static boolean log(Level level, Throwable t, String format, Object ... arguments) {
        return Logger.log(LogFactory.get(CallerUtils.getCallers()), level, t, format, arguments);
    }

    public static boolean log(Log log, Level level, Throwable t, String format, Object ... arguments) {
        if (log instanceof LocationAware) {
            ((LocationAware)log).log(FQCN, level, t, format, arguments);
            return true;
        }
        return false;
    }

    public static Log get(Class<?> clazz) {
        return LogFactory.get(clazz);
    }

    public static Log get(String name) {
        return LogFactory.get(name);
    }

    public static Log get() {
        return LogFactory.get(CallerUtils.getCallers());
    }
}

