/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.logger.dialect.commons;

import org.aoju.bus.logger.Log;
import org.aoju.bus.logger.LogFactory;
import org.aoju.bus.logger.dialect.commons.ApacheCommonsLog;
import org.aoju.bus.logger.dialect.commons.ApacheCommonsLog4J;

public class ApacheCommonsLogFactory
extends LogFactory {
    public ApacheCommonsLogFactory() {
        super("Apache Common Logging");
        this.checkLogExist(org.apache.commons.logging.LogFactory.class);
    }

    @Override
    public Log createLog(String name) {
        try {
            return new ApacheCommonsLog4J(name);
        }
        catch (Exception e) {
            return new ApacheCommonsLog(name);
        }
    }

    @Override
    public Log createLog(Class<?> clazz) {
        try {
            return new ApacheCommonsLog4J(clazz);
        }
        catch (Exception e) {
            return new ApacheCommonsLog(clazz);
        }
    }

    @Override
    protected void checkLogExist(Object logClassName) {
        super.checkLogExist(logClassName);
        this.getLog(ApacheCommonsLogFactory.class);
    }
}

