/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.logger.dialect.jdk;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.logger.AbstractAware;

public class Jdk
extends AbstractAware {
    private static final long serialVersionUID = -6843151523380063975L;
    private static final String FQCN_SELF = Jdk.class.getName();
    private final transient Logger logger;

    public Jdk(Logger logger) {
        this.logger = logger;
    }

    public Jdk(Class<?> clazz) {
        this(clazz.getName());
    }

    public Jdk(String name) {
        this(Logger.getLogger(name));
    }

    private static void fillCallerData(String caller, LogRecord record) {
        StackTraceElement[] steArray = new Throwable().getStackTrace();
        int found = -1;
        for (int i = 0; i < steArray.length; ++i) {
            String className = steArray[i].getClassName();
            if (!className.equals(caller)) continue;
            found = i;
            break;
        }
        if (found > -1 && found < steArray.length - 1) {
            StackTraceElement ste = steArray[found + 1];
            record.setSourceClassName(ste.getClassName());
            record.setSourceMethodName(ste.getMethodName());
        }
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINEST);
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.logIfEnabled(Level.FINEST, null, format, arguments);
    }

    @Override
    public void trace(Throwable t, String format, Object ... arguments) {
        this.logIfEnabled(Level.FINEST, t, format, arguments);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.logIfEnabled(Level.FINE, null, format, arguments);
    }

    @Override
    public void debug(Throwable t, String format, Object ... arguments) {
        this.logIfEnabled(Level.FINE, t, format, arguments);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.logIfEnabled(Level.INFO, null, format, arguments);
    }

    @Override
    public void info(Throwable t, String format, Object ... arguments) {
        this.logIfEnabled(Level.INFO, t, format, arguments);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.logIfEnabled(Level.WARNING, null, format, arguments);
    }

    @Override
    public void warn(Throwable t, String format, Object ... arguments) {
        this.logIfEnabled(Level.WARNING, t, format, arguments);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.logIfEnabled(Level.SEVERE, null, format, arguments);
    }

    @Override
    public void error(Throwable t, String format, Object ... arguments) {
        this.logIfEnabled(Level.SEVERE, t, format, arguments);
    }

    @Override
    public void log(org.aoju.bus.logger.level.Level level, String format, Object ... arguments) {
        this.log(level, null, format, arguments);
    }

    @Override
    public void log(org.aoju.bus.logger.level.Level level, Throwable t, String format, Object ... arguments) {
        this.log(FQCN_SELF, level, t, format, arguments);
    }

    @Override
    public void log(String fqcn, org.aoju.bus.logger.level.Level level, Throwable t, String format, Object ... arguments) {
        Level jdkLevel;
        switch (level) {
            case TRACE: {
                jdkLevel = Level.FINEST;
                break;
            }
            case DEBUG: {
                jdkLevel = Level.FINE;
                break;
            }
            case INFO: {
                jdkLevel = Level.INFO;
                break;
            }
            case WARN: {
                jdkLevel = Level.WARNING;
                break;
            }
            case ERROR: {
                jdkLevel = Level.SEVERE;
                break;
            }
            default: {
                throw new Error(StringUtils.format("Can not identify level: {}", new Object[]{level}));
            }
        }
        this.logIfEnabled(fqcn, jdkLevel, t, format, arguments);
    }

    private void logIfEnabled(Level level, Throwable throwable, String format, Object[] arguments) {
        this.logIfEnabled(FQCN_SELF, level, throwable, format, arguments);
    }

    private void logIfEnabled(String callerFQCN, Level level, Throwable throwable, String format, Object[] arguments) {
        if (this.logger.isLoggable(level)) {
            LogRecord record = new LogRecord(level, StringUtils.format(format, arguments));
            record.setLoggerName(this.getName());
            record.setThrown(throwable);
            Jdk.fillCallerData(callerFQCN, record);
            this.logger.log(record);
        }
    }
}

