/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.logger.dialect.log4j;

import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.logger.AbstractAware;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4J
extends AbstractAware {
    private static final long serialVersionUID = -6843151523380063975L;
    private static final String FQCN = Log4J.class.getName();
    private final Logger logger;

    public Log4J(Logger logger) {
        this.logger = logger;
    }

    public Log4J(Class<?> clazz) {
        this(Logger.getLogger(clazz));
    }

    public Log4J(String name) {
        this(Logger.getLogger((String)name));
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.trace(null, format, arguments);
    }

    @Override
    public void trace(Throwable t, String format, Object ... arguments) {
        this.logger.log(FQCN, (Priority)Level.TRACE, (Object)StringUtils.format(format, arguments), t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.debug(null, format, arguments);
    }

    @Override
    public void debug(Throwable t, String format, Object ... arguments) {
        this.logger.log(FQCN, (Priority)Level.DEBUG, (Object)StringUtils.format(format, arguments), t);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.info(null, format, arguments);
    }

    @Override
    public void info(Throwable t, String format, Object ... arguments) {
        this.logger.log(FQCN, (Priority)Level.INFO, (Object)StringUtils.format(format, arguments), t);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.warn(null, format, arguments);
    }

    @Override
    public void warn(Throwable t, String format, Object ... arguments) {
        this.logger.log(FQCN, (Priority)Level.WARN, (Object)StringUtils.format(format, arguments), t);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)Level.ERROR);
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.error(null, format, arguments);
    }

    @Override
    public void error(Throwable t, String format, Object ... arguments) {
        this.logger.log(FQCN, (Priority)Level.ERROR, (Object)StringUtils.format(format, arguments), t);
    }

    @Override
    public void log(org.aoju.bus.logger.level.Level level, String format, Object ... arguments) {
        this.log(level, null, format, arguments);
    }

    @Override
    public void log(org.aoju.bus.logger.level.Level level, Throwable t, String format, Object ... arguments) {
        this.log(FQCN, level, t, format, arguments);
    }

    @Override
    public void log(String fqcn, org.aoju.bus.logger.level.Level level, Throwable t, String format, Object ... arguments) {
        Level log4jLevel;
        switch (level) {
            case TRACE: {
                log4jLevel = Level.TRACE;
                break;
            }
            case DEBUG: {
                log4jLevel = Level.DEBUG;
                break;
            }
            case INFO: {
                log4jLevel = Level.INFO;
                break;
            }
            case WARN: {
                log4jLevel = Level.WARN;
                break;
            }
            case ERROR: {
                log4jLevel = Level.ERROR;
                break;
            }
            default: {
                throw new Error(StringUtils.format("Can not identify level: {}", new Object[]{level}));
            }
        }
        this.logger.log(fqcn, (Priority)log4jLevel, (Object)StringUtils.format(format, arguments), t);
    }
}

