/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.logger.dialect.log4j2;

import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.logger.AbstractAware;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.spi.AbstractLogger;

public class Log4J2
extends AbstractAware {
    private static final long serialVersionUID = -6843151523380063975L;
    private static final String FQCN = Log4J2.class.getName();
    private final transient Logger logger;

    public Log4J2(Logger logger) {
        this.logger = logger;
    }

    public Log4J2(Class<?> clazz) {
        this(LogManager.getLogger(clazz));
    }

    public Log4J2(String name) {
        this(LogManager.getLogger((String)name));
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.trace(null, format, arguments);
    }

    @Override
    public void trace(Throwable t, String format, Object ... arguments) {
        if (!this.logIfEnabled(Level.TRACE, t, format, arguments)) {
            this.logger.trace(StringUtils.format(format, arguments), t);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.debug(null, format, arguments);
    }

    @Override
    public void debug(Throwable t, String format, Object ... arguments) {
        if (!this.logIfEnabled(Level.DEBUG, t, format, arguments)) {
            this.logger.debug(StringUtils.format(format, arguments), t);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.info(null, format, arguments);
    }

    @Override
    public void info(Throwable t, String format, Object ... arguments) {
        if (!this.logIfEnabled(Level.INFO, t, format, arguments)) {
            this.logger.info(StringUtils.format(format, arguments), t);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.warn(null, format, arguments);
    }

    @Override
    public void warn(Throwable t, String format, Object ... arguments) {
        if (!this.logIfEnabled(Level.WARN, t, format, arguments)) {
            this.logger.warn(StringUtils.format(format, arguments), t);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.error(null, format, arguments);
    }

    @Override
    public void error(Throwable t, String format, Object ... arguments) {
        if (!this.logIfEnabled(Level.ERROR, t, format, arguments)) {
            this.logger.warn(StringUtils.format(format, arguments), t);
        }
    }

    @Override
    public void log(org.aoju.bus.logger.level.Level level, String format, Object ... arguments) {
        this.log(level, null, format, arguments);
    }

    @Override
    public void log(org.aoju.bus.logger.level.Level level, Throwable t, String format, Object ... arguments) {
        this.log(FQCN, level, t, format, arguments);
    }

    @Override
    public void log(String fqcn, org.aoju.bus.logger.level.Level level, Throwable t, String format, Object ... arguments) {
        Level log4j2Level;
        switch (level) {
            case TRACE: {
                log4j2Level = Level.TRACE;
                break;
            }
            case DEBUG: {
                log4j2Level = Level.DEBUG;
                break;
            }
            case INFO: {
                log4j2Level = Level.INFO;
                break;
            }
            case WARN: {
                log4j2Level = Level.WARN;
                break;
            }
            case ERROR: {
                log4j2Level = Level.ERROR;
                break;
            }
            default: {
                throw new Error(StringUtils.format("Can not identify level: {}", new Object[]{level}));
            }
        }
        this.logIfEnabled(fqcn, log4j2Level, t, format, arguments);
    }

    private boolean logIfEnabled(Level level, Throwable t, String msgTemplate, Object ... arguments) {
        return this.logIfEnabled(FQCN, level, t, msgTemplate, arguments);
    }

    private boolean logIfEnabled(String fqcn, Level level, Throwable t, String msgTemplate, Object ... arguments) {
        if (this.logger instanceof AbstractLogger) {
            ((AbstractLogger)this.logger).logIfEnabled(fqcn, level, null, StringUtils.format(msgTemplate, arguments), t);
            return true;
        }
        return false;
    }
}

