/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.logger.dialect.slf4j;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.status.Status;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.aoju.bus.logger.Log;
import org.aoju.bus.logger.LogFactory;
import org.aoju.bus.logger.dialect.slf4j.Slf4J;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLoggerFactory;

public class Slf4jLogFactory
extends LogFactory {
    public Slf4jLogFactory() {
        this(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Slf4jLogFactory(boolean failIfNOP) {
        super("Slf4j");
        this.checkLogExist(LoggerFactory.class);
        if (!failIfNOP) {
            return;
        }
        final StringBuilder buf = new StringBuilder();
        PrintStream err = System.err;
        try {
            System.setErr(new PrintStream(new OutputStream(){

                @Override
                public void write(int b) {
                    buf.append((char)b);
                }
            }, true, "UTF-8"));
            OutputStreamAppender s = new OutputStreamAppender();
            s.setEncoder(new Encoder(){

                public byte[] headerBytes() {
                    return new byte[0];
                }

                public byte[] encode(Object event) {
                    return new byte[0];
                }

                public byte[] footerBytes() {
                    return new byte[0];
                }

                public Context getContext() {
                    return null;
                }

                public void setContext(Context context) {
                }

                public void addStatus(Status status) {
                }

                public void addInfo(String msg) {
                }

                public void addInfo(String msg, Throwable ex) {
                }

                public void addWarn(String msg) {
                }

                public void addWarn(String msg, Throwable ex) {
                }

                public void addError(String msg) {
                }

                public void addError(String msg, Throwable ex) {
                }

                public void start() {
                }

                public void stop() {
                }

                public boolean isStarted() {
                    return false;
                }
            });
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
        try {
            if (LoggerFactory.getILoggerFactory() instanceof NOPLoggerFactory) {
                throw new NoClassDefFoundError(buf.toString());
            }
            err.print(buf);
            err.flush();
        }
        finally {
            System.setErr(err);
        }
    }

    @Override
    public Log createLog(String name) {
        return new Slf4J(name);
    }

    @Override
    public Log createLog(Class<?> clazz) {
        return new Slf4J(clazz);
    }
}

