/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.aoju.bus.core.lang.exception.CommonException;

public class NioClient {
    private SocketChannel channel;

    public NioClient(String host, int port) {
        this.init(new InetSocketAddress(host, port));
    }

    public NioClient(InetSocketAddress address) {
        this.init(address);
    }

    public NioClient init(InetSocketAddress address) {
        try {
            this.channel = SocketChannel.open(address);
        }
        catch (IOException e) {
            throw new CommonException(e);
        }
        return this;
    }

    public NioClient read(ByteBuffer buffer) {
        try {
            this.channel.read(buffer);
        }
        catch (IOException e) {
            throw new CommonException(e);
        }
        return this;
    }

    public NioClient write(ByteBuffer ... datas) {
        try {
            this.channel.write(datas);
        }
        catch (IOException e) {
            throw new CommonException(e);
        }
        return this;
    }
}

