/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring.limiter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.limiter.LimiterAnnotationParser;
import org.aoju.bus.limiter.interceptor.BeanFactoryLimitedResourceSourceAdvisor;
import org.aoju.bus.limiter.interceptor.LimiterInterceptor;
import org.aoju.bus.limiter.source.DefaultLimitedResourceSource;
import org.aoju.bus.limiter.source.LimitedResourceSource;
import org.aoju.bus.spring.limiter.AbstractLimiterConfiguration;
import org.aoju.bus.spring.limiter.DefaultConfiguration;
import org.aopalliance.aop.Advice;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Role;
import org.springframework.core.io.ResourceLoader;

@Role(value=2)
@Import(value={DefaultConfiguration.class})
public class LimiterConfiguration
extends AbstractLimiterConfiguration
implements ResourceLoaderAware {
    ResourceLoader resourceLoader;

    @Bean
    @Role(value=2)
    public BeanFactoryLimitedResourceSourceAdvisor limiterAdvisor() {
        BeanFactoryLimitedResourceSourceAdvisor advisor = new BeanFactoryLimitedResourceSourceAdvisor(this.limitedResourceSource());
        advisor.setAdvice((Advice)this.limiterInterceptor());
        if (this.enableLimiter != null) {
            advisor.setOrder((Integer)this.enableLimiter.getNumber("order"));
        }
        return advisor;
    }

    @Bean
    @Role(value=2)
    public LimitedResourceSource limitedResourceSource() {
        int i;
        String[] parsersClassNames = this.enableLimiter.getStringArray("annotationParser");
        List<String> defaultParsers = this.findDefaultParsers();
        if (!CollUtils.isEmpty(defaultParsers)) {
            int len = parsersClassNames.length;
            parsersClassNames = Arrays.copyOf(parsersClassNames, parsersClassNames.length + defaultParsers.size());
            for (i = 0; i < defaultParsers.size(); ++i) {
                parsersClassNames[i + len] = defaultParsers.get(i);
            }
        }
        LimiterAnnotationParser[] parsers = new LimiterAnnotationParser[parsersClassNames.length];
        for (i = 0; i < parsersClassNames.length; ++i) {
            try {
                Class<?> parserClass = Class.forName(parsersClassNames[i]);
                parsers[i] = (LimiterAnnotationParser)parserClass.newInstance();
                continue;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new InstrumentException("Class Not Found!");
            }
        }
        return new DefaultLimitedResourceSource(parsers);
    }

    private List<String> findDefaultParsers() {
        String[] parsers = new String[]{"LockAnnotationParser", "RateLimiterAnnotationParser", "PeakLimiterAnnotationParser"};
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < parsers.length; ++i) {
            try {
                Class.forName(parsers[i]);
                ret.add(parsers[i]);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return ret;
    }

    @Bean
    @Role(value=2)
    public LimiterInterceptor limiterInterceptor() {
        LimiterInterceptor interceptor = new LimiterInterceptor();
        interceptor.setLimitedResourceSource(this.limitedResourceSource());
        return interceptor;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

