/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.storage.magic;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.lang.exception.CommonException;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.storage.magic.MagicMatch;
import org.aoju.bus.storage.magic.MagicMatcher;
import org.aoju.bus.storage.magic.MagicParser;

public class Magic {
    private static boolean initialized = false;
    private static MagicParser magicParser = null;
    private static Map<String, List<MagicMatcher>> hintMap = new HashMap<String, List<MagicMatcher>>();

    private static void addHint(String extension, MagicMatcher matcher) {
        if (hintMap.keySet().contains(extension)) {
            List<MagicMatcher> a = hintMap.get(extension);
            a.add(matcher);
        } else {
            ArrayList<MagicMatcher> a = new ArrayList<MagicMatcher>();
            a.add(matcher);
            hintMap.put(extension, a);
        }
    }

    public static synchronized void initialize() throws CommonException {
        if (!initialized) {
            magicParser = new MagicParser();
            magicParser.initialize();
            for (MagicMatcher matcher : magicParser.getMatchers()) {
                String ext = matcher.getMatch().getExtension();
                if (ext != null && !ext.trim().equals("")) {
                    Magic.addHint(ext, matcher);
                    continue;
                }
                if (!matcher.getMatch().getType().equals("detector")) continue;
                String[] exts = matcher.getDetectorExtensions();
                for (int j = 0; j < exts.length; ++j) {
                    Magic.addHint(exts[j], matcher);
                }
            }
            initialized = true;
        }
    }

    public static Collection<MagicMatcher> getMatchers() throws CommonException {
        if (!initialized) {
            Magic.initialize();
        }
        Iterator<MagicMatcher> i = magicParser.getMatchers().iterator();
        ArrayList<MagicMatcher> m = new ArrayList<MagicMatcher>();
        while (i.hasNext()) {
            MagicMatcher matcher = i.next();
            try {
                m.add(matcher.clone());
            }
            catch (CloneNotSupportedException e) {
                throw new CommonException("failed to clone matchers");
            }
        }
        return m;
    }

    public static MagicMatch getMagicMatch(byte[] data) throws CommonException {
        return Magic.getMagicMatch(data, false);
    }

    public static MagicMatch getMagicMatch(byte[] data, boolean onlyMimeMatch) throws CommonException {
        if (!initialized) {
            Magic.initialize();
        }
        Collection<MagicMatcher> matchers = magicParser.getMatchers();
        MagicMatcher matcher2 = null;
        MagicMatch match = null;
        for (MagicMatcher matcher2 : matchers) {
            try {
                match = matcher2.test(data, onlyMimeMatch);
                if (match == null) continue;
                return match;
            }
            catch (CommonException e) {
                throw new CommonException(e);
            }
        }
        throw new CommonException();
    }

    public static MagicMatch getMagicMatch(File file, boolean extensionHints) throws CommonException {
        return Magic.getMagicMatch(file, extensionHints, false);
    }

    public static MagicMatch getMagicMatch(File file, boolean extensionHints, boolean onlyMimeMatch) throws CommonException {
        Collection c;
        String ext;
        String name;
        int pos;
        if (!initialized) {
            Magic.initialize();
        }
        long start = System.currentTimeMillis();
        MagicMatcher matcher2 = null;
        MagicMatch match = null;
        ArrayList<MagicMatcher> checked = new ArrayList<MagicMatcher>();
        if (extensionHints && (pos = (name = file.getName()).lastIndexOf(46)) > -1 && (ext = name.substring(pos + 1, name.length())) != null && !ext.equals("") && (c = (Collection)hintMap.get(ext)) != null) {
            for (MagicMatcher matcher2 : c) {
                try {
                    match = matcher2.test(file, onlyMimeMatch);
                    if (match != null) {
                        return match;
                    }
                }
                catch (CommonException e) {
                    throw new CommonException(e);
                }
                catch (IOException e) {
                    throw new CommonException(e);
                }
                checked.add(matcher2);
            }
        }
        Collection<MagicMatcher> matchers = magicParser.getMatchers();
        for (MagicMatcher matcher2 : matchers) {
            if (checked.contains(matcher2)) continue;
            try {
                match = matcher2.test(file, onlyMimeMatch);
                if (match == null) continue;
                return match;
            }
            catch (CommonException e) {
                throw new CommonException(e);
            }
            catch (IOException e) {
                throw new CommonException(e);
            }
        }
        throw new CommonException();
    }

    public static void printMagicFile(PrintStream stream) throws CommonException {
        if (!initialized) {
            Magic.initialize();
        }
        Collection<MagicMatcher> matchers = Magic.getMatchers();
        MagicMatcher matcher2 = null;
        for (MagicMatcher matcher2 : matchers) {
            Magic.printMagicMatcher(stream, matcher2, "");
        }
    }

    private static void printMagicMatcher(PrintStream stream, MagicMatcher matcher, String spacing) {
        stream.println(spacing + "name: " + matcher.getMatch().getDescription());
        stream.println(spacing + "children: ");
        Collection<MagicMatcher> matchers = matcher.getSubMatchers();
        Iterator<MagicMatcher> i = matchers.iterator();
        while (i.hasNext()) {
            Magic.printMagicMatcher(stream, i.next(), spacing + "  ");
        }
    }

    public static void printMagicMatch(PrintStream stream, MagicMatch match, String spacing) {
        stream.println(spacing + "=============================");
        stream.println(spacing + "mime type: " + match.getMimeType());
        stream.println(spacing + "description: " + match.getDescription());
        stream.println(spacing + "extension: " + match.getExtension());
        stream.println(spacing + "test: " + new String(match.getTest().array()));
        stream.println(spacing + "bitmask: " + match.getBitmask());
        stream.println(spacing + "offset: " + match.getOffset());
        stream.println(spacing + "length: " + match.getLength());
        stream.println(spacing + "type: " + match.getType());
        stream.println(spacing + "comparator: " + match.getComparator());
        stream.println(spacing + "=============================");
        Collection<MagicMatch> submatches = match.getSubMatches();
        Iterator<MagicMatch> i = submatches.iterator();
        while (i.hasNext()) {
            Magic.printMagicMatch(stream, i.next(), spacing + "    ");
        }
    }

    public static void main(String[] args) {
        try {
            File f;
            if (args.length == 0) {
                System.err.println("usage: test <file>");
                System.exit(1);
            }
            if ((f = new File(args[0])).exists()) {
                MagicMatch match = Magic.getMagicMatch(f, true, false);
                Magic.printMagicMatch(System.out, match, "");
            }
        }
        catch (CommonException e) {
            throw new InstrumentException(e);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }
}

