/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.storage.magic;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MagicMatch
implements Cloneable {
    private String mimeType = null;
    private String extension = null;
    private String description = null;
    private ByteBuffer test = null;
    private int offset = 0;
    private int length = 0;
    private String type = "";
    private long bitmask = 0xFFFFFFFFL;
    private char comparator = '\u0000';
    private List<MagicMatch> subMatches = new ArrayList<MagicMatch>(0);
    private Map<String, String> properties;

    public String print() {
        StringBuffer string = new StringBuffer();
        string.append("\n");
        string.append("mime type: ").append(this.mimeType).append("\n");
        string.append("description: ").append(this.description).append("\n");
        string.append("extension: ").append(this.extension).append("\n");
        string.append("offset: ").append(this.offset).append("\n");
        string.append("length: ").append(this.length).append("\n");
        string.append("test: ").append(new String(this.test.array())).append("\n");
        string.append("type: ").append(this.type).append("\n");
        string.append("comparator: ").append(this.comparator).append("\n");
        string.append("bitmask: ").append(this.bitmask);
        return string.toString();
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String value) {
        this.mimeType = value;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String value) {
        this.extension = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public ByteBuffer getTest() {
        return this.test;
    }

    public void setTest(ByteBuffer value) {
        this.test = value;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int value) {
        this.offset = value;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int value) {
        this.length = value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String value) {
        this.type = value;
    }

    public long getBitmask() {
        return this.bitmask;
    }

    public void setBitmask(String value) {
        if (value != null) {
            this.bitmask = Long.decode(value).intValue();
        }
    }

    public char getComparator() {
        return this.comparator;
    }

    public void setComparator(String value) {
        this.comparator = value.charAt(0);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void addSubMatch(MagicMatch m) {
        this.subMatches.add(m);
    }

    public Collection<MagicMatch> getSubMatches() {
        return this.subMatches;
    }

    public void setSubMatches(Collection<MagicMatch> a) {
        this.subMatches.clear();
        this.subMatches.addAll(a);
    }

    public boolean descriptionMatches(String desc) {
        if (this.description != null && this.description.equals(desc)) {
            return true;
        }
        Collection<MagicMatch> submatches = this.getSubMatches();
        Iterator<MagicMatch> i = submatches.iterator();
        MagicMatch m = null;
        while (i.hasNext()) {
            m = i.next();
            if (!m.descriptionMatches(desc)) continue;
            return true;
        }
        return false;
    }

    public boolean mimeTypeMatches(String desc) {
        if (this.mimeType != null && this.mimeType.equals(desc)) {
            return true;
        }
        Collection<MagicMatch> submatches = this.getSubMatches();
        Iterator<MagicMatch> i = submatches.iterator();
        MagicMatch m = null;
        while (i.hasNext()) {
            m = i.next();
            if (!m.mimeTypeMatches(desc)) continue;
            return true;
        }
        return false;
    }

    protected Object clone() throws CloneNotSupportedException {
        MagicMatch clone = new MagicMatch();
        clone.setBitmask(Long.toString(this.bitmask, 8));
        clone.setComparator("" + this.comparator);
        clone.setDescription(this.description);
        clone.setExtension(this.extension);
        clone.setLength(this.length);
        clone.setMimeType(this.mimeType);
        clone.setOffset(this.offset);
        if (this.properties != null) {
            HashMap<String, String> m = new HashMap<String, String>();
            m.putAll(this.properties);
            clone.setProperties(m);
        }
        Iterator<MagicMatch> i = this.subMatches.iterator();
        ArrayList<MagicMatch> a = new ArrayList<MagicMatch>();
        while (i.hasNext()) {
            MagicMatch mm = i.next();
            a.add(mm);
        }
        clone.setSubMatches(a);
        clone.setTest(this.test);
        clone.setType(this.type);
        return clone;
    }
}

