/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cache;

import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.aoju.bus.cache.CacheConfig;
import org.aoju.bus.cache.CacheCore;
import org.aoju.bus.cache.provider.BaseProvider;
import org.aoju.bus.cache.reader.AbstractCacheReader;
import org.aoju.bus.cache.reader.MultiCacheReader;
import org.aoju.bus.cache.reader.SingleCacheReader;
import org.aoju.bus.cache.support.cache.Cache;
import org.aoju.bus.core.utils.CollUtils;

public class CacheModule
extends AbstractModule {
    private static final AtomicBoolean init = new AtomicBoolean(false);
    private static Injector injector;
    private CacheConfig config;

    private CacheModule(CacheConfig config) {
        this.config = config;
    }

    public static synchronized CacheCore coreInstance(CacheConfig config) {
        if (init.compareAndSet(false, true)) {
            injector = Guice.createInjector((Module[])new Module[]{new CacheModule(config)});
        }
        return (CacheCore)injector.getInstance(CacheCore.class);
    }

    protected void configure() {
        Preconditions.checkArgument((this.config != null ? 1 : 0) != 0, (Object)"config param can not be null.");
        Preconditions.checkArgument((boolean)CollUtils.isNotEmpty(this.config.getCaches()), (Object)"caches param can not be empty.");
        this.bind(CacheConfig.class).toInstance((Object)this.config);
        MapBinder mapBinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, Cache.class);
        this.config.getCaches().forEach((name, cache) -> mapBinder.addBinding(name).toInstance(cache));
        Optional.ofNullable(this.config.getProvider()).ifPresent(mxBean -> this.bind(BaseProvider.class).toInstance(mxBean));
        this.bind(AbstractCacheReader.class).annotatedWith((Annotation)Names.named((String)"singleCacheReader")).to(SingleCacheReader.class);
        this.bind(AbstractCacheReader.class).annotatedWith((Annotation)Names.named((String)"multiCacheReader")).to(MultiCacheReader.class);
    }
}

