/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.resource;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import org.aoju.bus.core.consts.Charset;
import org.aoju.bus.core.io.resource.Resource;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.FileUtils;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.core.utils.URLUtils;

public class UrlResource
implements Resource {
    protected URL url;
    protected String name;

    public UrlResource(URL url) {
        this(url, null);
    }

    public UrlResource(URL url, String name) {
        this.url = url;
        this.name = ObjectUtils.defaultIfNull(name, null != url ? FileUtils.getName(url.getPath()) : null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public InputStream getStream() {
        if (null == this.url) {
            throw new InstrumentException("Resource [{" + this.url + "}] not exist!");
        }
        return URLUtils.getStream(this.url);
    }

    @Override
    public BufferedReader getReader(java.nio.charset.Charset charset) {
        return URLUtils.getReader(this.url, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readStr(java.nio.charset.Charset charset) throws InstrumentException {
        BufferedReader reader = null;
        try {
            reader = this.getReader(charset);
            String string = IoUtils.read(reader);
            return string;
        }
        finally {
            IoUtils.close(reader);
        }
    }

    @Override
    public String readUtf8Str() throws InstrumentException {
        return this.readStr(Charset.UTF_8);
    }

    @Override
    public byte[] readBytes() throws InstrumentException {
        InputStream in = null;
        try {
            in = this.getStream();
            byte[] byArray = IoUtils.readBytes(in);
            return byArray;
        }
        finally {
            IoUtils.close(in);
        }
    }

    public File getFile() {
        return FileUtils.file(this.url);
    }

    public String toString() {
        return null == this.url ? "null" : this.url.toString();
    }
}

