/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.loader;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.aoju.bus.core.lang.exception.CommonException;
import org.aoju.bus.core.utils.ClassUtils;
import org.aoju.bus.core.utils.FileUtils;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.ReflectUtils;
import org.aoju.bus.core.utils.URLUtils;

public class JarClassLoader
extends URLClassLoader {
    public JarClassLoader() {
        this(new URL[0]);
    }

    public JarClassLoader(URL[] urls) {
        super(urls, ClassUtils.getClassLoader());
    }

    public static JarClassLoader load(File dir) {
        JarClassLoader loader = new JarClassLoader();
        loader.addJar(dir);
        loader.addURL(dir);
        return loader;
    }

    public static JarClassLoader loadJar(File jarFile) {
        JarClassLoader loader = new JarClassLoader();
        try {
            loader.addJar(jarFile);
        }
        finally {
            IoUtils.close(loader);
        }
        return loader;
    }

    public static void loadJar(URLClassLoader loader, File jarFile) throws CommonException {
        try {
            Method method = ClassUtils.getDeclaredMethod(URLClassLoader.class, "addURL", URL.class);
            if (null != method) {
                method.setAccessible(true);
                List<File> jars = JarClassLoader.loopJar(jarFile);
                for (File jar : jars) {
                    ReflectUtils.invoke((Object)loader, method, jar.toURI().toURL());
                }
            }
        }
        catch (IOException e) {
            throw new CommonException(e);
        }
    }

    public static URLClassLoader loadJarToSystemClassLoader(File jarFile) {
        URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        JarClassLoader.loadJar(urlClassLoader, jarFile);
        return urlClassLoader;
    }

    private static List<File> loopJar(File file) {
        return FileUtils.loopFiles(file, new FileFilter(){

            @Override
            public boolean accept(File file) {
                String path = file.getPath();
                return path != null && path.toLowerCase().endsWith(".jar");
            }
        });
    }

    private static boolean isJarFile(File file) {
        if (!FileUtils.isFile(file)) {
            return false;
        }
        return file.getPath().toLowerCase().endsWith(".jar");
    }

    public JarClassLoader addJar(File jarFile) {
        List<File> jars = JarClassLoader.loopJar(jarFile);
        try {
            for (File jar : jars) {
                super.addURL(jar.toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new CommonException(e);
        }
        return this;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    public JarClassLoader addURL(File dir) {
        super.addURL(URLUtils.getURL(dir));
        return this;
    }
}

