/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.utils;

import java.io.Serializable;
import java.util.Arrays;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.NumberUtils;

public class TextUtils
implements CharSequence,
Appendable,
Serializable {
    public static final int DEFAULT_CAPACITY = 16;
    private char[] value;
    private int position;

    public TextUtils() {
        this(16);
    }

    public TextUtils(int initialCapacity) {
        this.value = new char[initialCapacity];
    }

    public TextUtils(CharSequence ... strs) {
        this(ArrayUtils.isEmpty(strs) ? 16 : TextUtils.totalLength(strs) + 16);
        for (int i = 0; i < strs.length; ++i) {
            this.append(strs[i]);
        }
    }

    public static TextUtils create() {
        return new TextUtils();
    }

    public static TextUtils create(int initialCapacity) {
        return new TextUtils(initialCapacity);
    }

    public static TextUtils create(CharSequence ... strs) {
        return new TextUtils(strs);
    }

    private static int totalLength(CharSequence ... strs) {
        int totalLength = 0;
        for (int i = 0; i < strs.length; ++i) {
            totalLength += null == strs[i] ? 4 : strs[i].length();
        }
        return totalLength;
    }

    public static double similar(String strA, String strB) {
        String newStrB;
        String newStrA;
        if (strA.length() < strB.length()) {
            newStrA = TextUtils.removeSign(strB);
            newStrB = TextUtils.removeSign(strA);
        } else {
            newStrA = TextUtils.removeSign(strA);
            newStrB = TextUtils.removeSign(strB);
        }
        int temp = Math.max(newStrA.length(), newStrB.length());
        int temp2 = TextUtils.longestCommonSubstring(newStrA, newStrB).length();
        return NumberUtils.div((float)temp2, (float)temp);
    }

    public static String similar(String strA, String strB, int scale) {
        return NumberUtils.formatPercent(TextUtils.similar(strA, strB), scale);
    }

    private static String removeSign(String str) {
        StringBuilder sb = new StringBuilder(str.length());
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            sb.append(TextUtils.charReg(str.charAt(i)));
        }
        return sb.toString();
    }

    private static boolean charReg(char charValue) {
        return charValue >= '\u4e00' && charValue <= '\u0fff' || charValue >= 'a' && charValue <= 'z' || charValue >= 'A' && charValue <= 'Z' || charValue >= '0' && charValue <= '9';
    }

    private static String longestCommonSubstring(String strA, String strB) {
        char[] chars_strA = strA.toCharArray();
        char[] chars_strB = strB.toCharArray();
        int m = chars_strA.length;
        int n = chars_strB.length;
        int[][] matrix = new int[m + 1][n + 1];
        for (int i = 1; i <= m; ++i) {
            for (int j = 1; j <= n; ++j) {
                matrix[i][j] = chars_strA[i - 1] == chars_strB[j - 1] ? matrix[i - 1][j - 1] + 1 : Math.max(matrix[i][j - 1], matrix[i - 1][j]);
            }
        }
        char[] result = new char[matrix[m][n]];
        int currentIndex = result.length - 1;
        while (matrix[m][n] != 0) {
            if (matrix[m][n] == matrix[m][n - 1]) {
                --n;
                continue;
            }
            if (matrix[m][n] == matrix[m - 1][n]) {
                --m;
                continue;
            }
            result[currentIndex] = chars_strA[m - 1];
            --currentIndex;
            --n;
            --m;
        }
        return new String(result);
    }

    public TextUtils append(Object obj) {
        return this.insert(this.position, obj);
    }

    @Override
    public TextUtils append(char c) {
        return this.insert(this.position, c);
    }

    public TextUtils append(char[] src) {
        if (ArrayUtils.isEmpty(src)) {
            return this;
        }
        return this.append(src, 0, src.length);
    }

    public TextUtils append(char[] src, int srcPos, int length) {
        return this.insert(this.position, src, srcPos, length);
    }

    @Override
    public TextUtils append(CharSequence csq) {
        return this.insert(this.position, csq);
    }

    @Override
    public TextUtils append(CharSequence csq, int start, int end) {
        return this.insert(this.position, csq, start, end);
    }

    public TextUtils insert(int index, Object obj) {
        if (obj instanceof CharSequence) {
            return this.insert(index, (CharSequence)obj);
        }
        return this.insert(index, Convert.toStr(obj));
    }

    public TextUtils insert(int index, char c) {
        this.moveDataAfterIndex(index, 1);
        this.value[index] = c;
        this.position = Math.max(this.position, index) + 1;
        return this;
    }

    public TextUtils insert(int index, char[] src) {
        if (ArrayUtils.isEmpty(src)) {
            return this;
        }
        return this.insert(index, src, 0, src.length);
    }

    public TextUtils insert(int index, char[] src, int srcPos, int length) {
        if (ArrayUtils.isEmpty(src) || srcPos > src.length || length <= 0) {
            return this;
        }
        if (index < 0) {
            index = 0;
        }
        if (srcPos < 0) {
            srcPos = 0;
        } else if (srcPos + length > src.length) {
            length = src.length - srcPos;
        }
        this.moveDataAfterIndex(index, length);
        System.arraycopy(src, srcPos, this.value, index, length);
        this.position = Math.max(this.position, index) + length;
        return this;
    }

    public TextUtils insert(int index, CharSequence csq) {
        if (null == csq) {
            csq = "null";
        }
        int len = csq.length();
        this.moveDataAfterIndex(index, csq.length());
        if (csq instanceof String) {
            ((String)csq).getChars(0, len, this.value, index);
        } else if (csq instanceof StringBuilder) {
            ((StringBuilder)csq).getChars(0, len, this.value, index);
        } else if (csq instanceof StringBuffer) {
            ((StringBuffer)csq).getChars(0, len, this.value, index);
        } else if (csq instanceof TextUtils) {
            ((TextUtils)csq).getChars(0, len, this.value, index);
        } else {
            int i = 0;
            int j = this.position;
            while (i < len) {
                this.value[j] = csq.charAt(i);
                ++i;
                ++j;
            }
        }
        this.position = Math.max(this.position, index) + len;
        return this;
    }

    public TextUtils insert(int index, CharSequence csq, int start, int end) {
        int csqLen;
        if (csq == null) {
            csq = "null";
        }
        if (start > (csqLen = csq.length())) {
            return this;
        }
        if (start < 0) {
            start = 0;
        }
        if (end > csqLen) {
            end = csqLen;
        }
        if (start >= end) {
            return this;
        }
        if (index < 0) {
            index = 0;
        }
        int length = end - start;
        this.moveDataAfterIndex(index, length);
        int i = start;
        int j = this.position;
        while (i < end) {
            this.value[j] = csq.charAt(i);
            ++i;
            ++j;
        }
        this.position = Math.max(this.position, index) + length;
        return this;
    }

    public TextUtils getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin < 0) {
            srcBegin = 0;
        }
        if (srcEnd < 0) {
            srcEnd = 0;
        } else if (srcEnd > this.position) {
            srcEnd = this.position;
        }
        if (srcBegin > srcEnd) {
            throw new StringIndexOutOfBoundsException("srcBegin > srcEnd");
        }
        System.arraycopy(this.value, srcBegin, dst, dstBegin, srcEnd - srcBegin);
        return this;
    }

    public boolean hasContent() {
        return this.position > 0;
    }

    @Override
    public boolean isEmpty() {
        return this.position == 0;
    }

    public TextUtils clear() {
        return this.reset();
    }

    public TextUtils reset() {
        this.position = 0;
        return this;
    }

    public TextUtils delTo(int newPosition) {
        if (newPosition < 0) {
            this.reset();
        } else if (newPosition < this.position) {
            this.position = newPosition;
        }
        return this;
    }

    public TextUtils del(int start, int end) {
        int len;
        if (start < 0) {
            start = 0;
        }
        if (end > this.position) {
            end = this.position;
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException("Start is greater than End.");
        }
        if (end == this.position) {
            this.position = start;
        }
        if ((len = end - start) > 0) {
            System.arraycopy(this.value, start + len, this.value, start, this.position - end);
            this.position -= len;
        }
        return this;
    }

    public String toString(boolean isReset) {
        if (this.position > 0) {
            String s = new String(this.value, 0, this.position);
            if (isReset) {
                this.reset();
            }
            return s;
        }
        return "";
    }

    public String toStringAndReset() {
        return this.toString(true);
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    @Override
    public int length() {
        return this.position;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index > this.position) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.value[index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.subString(start, end);
    }

    public String subString(int start) {
        return this.subString(start, this.position);
    }

    public String subString(int start, int end) {
        return new String(this.value, start, end - start);
    }

    private void moveDataAfterIndex(int index, int length) {
        this.ensureCapacity(Math.max(this.position, index) + length);
        if (index < this.position) {
            System.arraycopy(this.value, index, this.value, index + length, this.position - index);
        } else if (index > this.position) {
            Arrays.fill(this.value, this.position, index, ' ');
        }
    }

    private void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity > this.value.length) {
            this.expandCapacity(minimumCapacity);
        }
    }

    private void expandCapacity(int minimumCapacity) {
        int newCapacity = this.value.length * 2 + 2;
        if (newCapacity < minimumCapacity) {
            newCapacity = minimumCapacity;
        }
        if (newCapacity < 0) {
            if (minimumCapacity < 0) {
                throw new OutOfMemoryError("Capacity is too long and max than Integer.MAX");
            }
            newCapacity = Integer.MAX_VALUE;
        }
        this.value = Arrays.copyOf(this.value, newCapacity);
    }
}

