/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.storage;

import java.util.HashMap;
import org.aoju.bus.core.utils.JsonUtils;
import org.aoju.bus.core.utils.StringUtils;

public class UploadToken {
    private long expires = 3600L;
    private String bucketName;
    private String fileType;
    private String uploadDir;
    private String fileName;
    private String callbackUrl;
    private String callbackBody;
    private String callbackHost;
    private boolean callbackBodyUseJson = false;
    private String mimeLimit;
    private Long fsizeMin;
    private Long fsizeMax;
    private Integer deleteAfterDays;

    public long getExpires() {
        return this.expires;
    }

    public void setExpires(long expires) {
        this.expires = expires;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getUploadDir() {
        return this.uploadDir;
    }

    public void setUploadDir(String uploadDir) {
        this.uploadDir = StringUtils.trimToNull(uploadDir);
        if (uploadDir != null) {
            if (!this.uploadDir.endsWith("/")) {
                this.uploadDir = this.uploadDir.concat("/");
            }
            if (this.uploadDir.startsWith("/")) {
                this.uploadDir = this.uploadDir.substring(1);
            }
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public String getCallbackBody() {
        return this.callbackBody;
    }

    public void setCallbackBody(String callbackBody) {
        this.callbackBody = callbackBody;
    }

    public String getCallbackHost() {
        return this.callbackHost;
    }

    public void setCallbackHost(String callbackHost) {
        this.callbackHost = callbackHost;
    }

    public void setCallbackBodyUseJson(boolean callbackBodyUseJson) {
        this.callbackBodyUseJson = callbackBodyUseJson;
    }

    public String getCallbackBodyType() {
        return this.callbackBodyUseJson ? "application/json" : "application/x-www-form-urlencoded";
    }

    public String getMimeLimit() {
        return this.mimeLimit;
    }

    public void setMimeLimit(String mimeLimit) {
        this.mimeLimit = mimeLimit;
    }

    public Long getFsizeMin() {
        return this.fsizeMin;
    }

    public void setFsizeMin(Long fsizeMin) {
        this.fsizeMin = fsizeMin;
    }

    public Long getFsizeMax() {
        return this.fsizeMax;
    }

    public void setFsizeMax(Long fsizeMax) {
        this.fsizeMax = fsizeMax;
    }

    public Integer getDeleteAfterDays() {
        return this.deleteAfterDays;
    }

    public void setDeleteAfterDays(Integer deleteAfterDays) {
        if (deleteAfterDays != null && deleteAfterDays > 0) {
            this.deleteAfterDays = deleteAfterDays;
        }
    }

    public String getFileKey() {
        if (StringUtils.isBlank(this.uploadDir) || StringUtils.isBlank(this.fileName)) {
            return this.fileName;
        }
        return this.uploadDir.concat(this.fileName);
    }

    public String getCallbackRuleAsJson() {
        if (StringUtils.isAnyBlank(this.callbackBody, this.callbackHost, this.callbackUrl)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("callbackBody", this.callbackBody);
        map.put("callbackHost", this.callbackHost);
        map.put("callbackUrl", this.callbackUrl);
        map.put("callbackBodyType", this.getCallbackBodyType());
        return JsonUtils.toJson(map);
    }
}

