/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.binding.apache.cxf.interceptor;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.aoju.bus.tracer.Backend;
import org.aoju.bus.tracer.config.TraceFilterConfiguration;
import org.aoju.bus.tracer.consts.TraceConsts;
import org.aoju.bus.tracer.transport.HttpHeaderTransport;
import org.aoju.bus.tracer.transport.jaxb.TpicMap;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractTraceOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTraceOutInterceptor.class);
    protected final Backend backend;
    private final HttpHeaderTransport httpSerializer;
    private final TraceFilterConfiguration.Channel channel;
    private String profile;

    public AbstractTraceOutInterceptor(String phase, TraceFilterConfiguration.Channel channel, Backend backend, String profile) {
        super(phase);
        this.channel = channel;
        this.backend = backend;
        this.profile = profile;
        this.httpSerializer = new HttpHeaderTransport();
    }

    public void handleMessage(Message message) {
        if (this.shouldHandleMessage(message)) {
            TraceFilterConfiguration filterConfiguration = this.backend.getConfiguration(this.profile);
            if (!this.backend.isEmpty() && filterConfiguration.shouldProcessContext(this.channel)) {
                Map<String, String> filteredParams = filterConfiguration.filterDeniedParams(this.backend.copyToMap(), this.channel);
                LOGGER.debug("Interceptor handles message!");
                if (Boolean.TRUE.equals(message.getExchange().get((Object)"org.apache.cxf.rest.message"))) {
                    HashMap<String, List<String>> responseHeaders = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
                    if (responseHeaders == null) {
                        responseHeaders = new HashMap<String, List<String>>();
                        message.put((Object)Message.PROTOCOL_HEADERS, responseHeaders);
                    }
                    String contextAsHeader = this.httpSerializer.render(filteredParams);
                    responseHeaders.put("TPIC", Collections.singletonList(contextAsHeader));
                } else {
                    try {
                        SoapMessage soapMessage = (SoapMessage)message;
                        this.addSoapHeader(filteredParams, soapMessage);
                    }
                    catch (NoClassDefFoundError e) {
                        LOGGER.error("Should handle SOAP-message but it seems that cxf soap dependency is not on the classpath. Unable to add Builder-Headers: {}", (Object)e.getMessage(), (Object)e);
                    }
                }
            }
        }
    }

    private void addSoapHeader(Map<String, String> filteredParams, SoapMessage soapMessage) {
        try {
            Header tpicHeader = new Header(TraceConsts.SOAP_HEADER_QNAME, (Object)TpicMap.wrap(filteredParams), (DataBinding)new JAXBDataBinding(new Class[]{TpicMap.class}));
            soapMessage.getHeaders().add(tpicHeader);
        }
        catch (JAXBException e) {
            LOGGER.warn("Error occured during Builder soap header creation: {}", (Object)e.getMessage());
            LOGGER.debug("Detailed exception", (Throwable)e);
        }
    }

    protected abstract boolean shouldHandleMessage(Message var1);
}

