/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.binding.jaxws;

import java.util.Map;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.tracer.Backend;
import org.aoju.bus.tracer.Builder;
import org.aoju.bus.tracer.binding.jaxws.AbstractTraceHandler;
import org.aoju.bus.tracer.config.TraceFilterConfiguration;
import org.aoju.bus.tracer.transport.SoapHeaderTransport;
import org.w3c.dom.Element;

public class TraceClientHandler
extends AbstractTraceHandler {
    private final SoapHeaderTransport transportSerialization = new SoapHeaderTransport();

    public TraceClientHandler() {
        this(Builder.getBackend());
    }

    public TraceClientHandler(Backend Backend2) {
        super(Backend2);
    }

    public final boolean handleFault(SOAPMessageContext context) {
        return true;
    }

    @Override
    protected final void handleIncoming(SOAPMessageContext context) {
        SOAPMessage msg = context.getMessage();
        if (msg != null && this.Backend.getConfiguration().shouldProcessContext(TraceFilterConfiguration.Channel.OutgoingRequest)) {
            try {
                SOAPHeader header = msg.getSOAPHeader();
                if (header != null) {
                    Map<String, String> parsedContext = this.transportSerialization.parseSoapHeader((Element)header);
                    this.Backend.putAll(this.Backend.getConfiguration().filterDeniedParams(parsedContext, TraceFilterConfiguration.Channel.OutgoingRequest));
                }
            }
            catch (SOAPException e) {
                Logger.warn("Error during precessing of inbound soap header: " + e.getMessage(), new Object[0]);
                Logger.debug("Detailed: Error during precessing of inbound soap header: {}", new Object[]{e.getMessage(), e});
            }
        }
    }

    @Override
    protected final void handleOutgoing(SOAPMessageContext context) {
        SOAPMessage msg = context.getMessage();
        if (msg != null && !this.Backend.isEmpty() && this.Backend.getConfiguration().shouldProcessContext(TraceFilterConfiguration.Channel.IncomingResponse)) {
            try {
                SOAPHeader header = this.getOrCreateHeader(msg);
                Map<String, String> filteredContext = this.Backend.getConfiguration().filterDeniedParams(this.Backend.copyToMap(), TraceFilterConfiguration.Channel.IncomingResponse);
                this.transportSerialization.renderSoapHeader(filteredContext, header);
                msg.saveChanges();
            }
            catch (SOAPException e) {
                Logger.warn("TraceClientHandler : Exception occurred during processing of outbound message.", new Object[]{e});
            }
        }
    }
}

