/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cache.support.serialize;

import org.aoju.bus.cache.support.serialize.BaseSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSerializer
implements BaseSerializer {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.github.jbox.serialize.BaseSerializer");

    protected abstract byte[] doSerialize(Object var1) throws Throwable;

    protected abstract Object doDeserialize(byte[] var1) throws Throwable;

    @Override
    public <T> byte[] serialize(T obj) {
        if (obj == null) {
            return null;
        }
        try {
            return this.doSerialize(obj);
        }
        catch (Throwable t) {
            logger.error("{} serialize error.", (Object)this.getClass().getName(), (Object)t);
            return null;
        }
    }

    @Override
    public <T> T deserialize(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return (T)this.doDeserialize(bytes);
        }
        catch (Throwable t) {
            logger.error("{} deserialize error.", (Object)this.getClass().getName(), (Object)t);
            return null;
        }
    }
}

