/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.utils;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchEvent;
import org.aoju.bus.core.io.watch.WatchMonitor;
import org.aoju.bus.core.io.watch.Watcher;
import org.aoju.bus.core.utils.UriUtils;

public class WatchUtils {
    public static WatchMonitor create(URL url, WatchEvent.Kind<?> ... events) {
        return WatchUtils.create(url, 0, events);
    }

    public static WatchMonitor create(URL url, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchUtils.create(UriUtils.toURI(url), maxDepth, events);
    }

    public static WatchMonitor create(URI uri, WatchEvent.Kind<?> ... events) {
        return WatchUtils.create(uri, 0, events);
    }

    public static WatchMonitor create(URI uri, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchUtils.create(Paths.get(uri), maxDepth, events);
    }

    public static WatchMonitor create(File file, WatchEvent.Kind<?> ... events) {
        return WatchUtils.create(file, 0, events);
    }

    public static WatchMonitor create(File file, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchUtils.create(file.toPath(), maxDepth, events);
    }

    public static WatchMonitor create(String path, WatchEvent.Kind<?> ... events) {
        return WatchUtils.create(path, 0, events);
    }

    public static WatchMonitor create(String path, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchUtils.create(Paths.get(path, new String[0]), maxDepth, events);
    }

    public static WatchMonitor create(Path path, WatchEvent.Kind<?> ... events) {
        return WatchUtils.create(path, 0, events);
    }

    public static WatchMonitor create(Path path, int maxDepth, WatchEvent.Kind<?> ... events) {
        return new WatchMonitor(path, maxDepth, events);
    }

    public static WatchMonitor createAll(URL url, Watcher watcher) {
        return WatchUtils.createAll(url, 0, watcher);
    }

    public static WatchMonitor createAll(URL url, int maxDepth, Watcher watcher) {
        return WatchUtils.createAll(UriUtils.toURI(url), maxDepth, watcher);
    }

    public static WatchMonitor createAll(URI uri, Watcher watcher) {
        return WatchUtils.createAll(uri, 0, watcher);
    }

    public static WatchMonitor createAll(URI uri, int maxDepth, Watcher watcher) {
        return WatchUtils.createAll(Paths.get(uri), maxDepth, watcher);
    }

    public static WatchMonitor createAll(File file, Watcher watcher) {
        return WatchUtils.createAll(file, 0, watcher);
    }

    public static WatchMonitor createAll(File file, int maxDepth, Watcher watcher) {
        return WatchUtils.createAll(file.toPath(), 0, watcher);
    }

    public static WatchMonitor createAll(String path, Watcher watcher) {
        return WatchUtils.createAll(path, 0, watcher);
    }

    public static WatchMonitor createAll(String path, int maxDepth, Watcher watcher) {
        return WatchUtils.createAll(Paths.get(path, new String[0]), maxDepth, watcher);
    }

    public static WatchMonitor createAll(Path path, Watcher watcher) {
        return WatchUtils.createAll(path, 0, watcher);
    }

    public static WatchMonitor createAll(Path path, int maxDepth, Watcher watcher) {
        WatchMonitor watchMonitor = WatchUtils.create(path, maxDepth, WatchMonitor.EVENTS_ALL);
        watchMonitor.setWatcher(watcher);
        return watchMonitor;
    }
}

