/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring.mapper;

import java.util.Properties;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.pager.plugin.PageInterceptor;
import org.aoju.bus.spring.mapper.MybatisProperties;
import org.aoju.bus.spring.mapper.SQLExplainHandler;
import org.aoju.bus.spring.mapper.SQLPerformanceHandler;
import org.apache.ibatis.plugin.Interceptor;

public class MybatisPluginBuilder {
    public static Interceptor[] build(MybatisProperties properties) {
        Interceptor[] plugins = new Interceptor[]{};
        if (ObjectUtils.isNotEmpty(properties)) {
            PageInterceptor interceptor = new PageInterceptor();
            Properties p = new Properties();
            p.setProperty("autoDelimitKeywords", properties.getAutoDelimitKeywords());
            p.setProperty("reasonable", properties.getReasonable());
            p.setProperty("supportMethodsArguments", properties.getSupportMethodsArguments());
            p.setProperty("returnPageInfo", properties.getReturnPageInfo());
            p.setProperty("params", properties.getParams());
            interceptor.setProperties(p);
            plugins = new Interceptor[]{interceptor, new SQLPerformanceHandler(), new SQLExplainHandler()};
        }
        return plugins;
    }
}

