/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.binding.spring.soap;

import org.aoju.bus.tracer.Backend;
import org.aoju.bus.tracer.Builder;
import org.aoju.bus.tracer.binding.spring.soap.AbstractTraceInterceptor;
import org.aoju.bus.tracer.config.TraceFilterConfiguration;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.EndpointInterceptor;

public final class TracendpointInterceptor
extends AbstractTraceInterceptor
implements EndpointInterceptor {
    public TracendpointInterceptor() {
        this(Builder.getBackend(), "default");
    }

    public TracendpointInterceptor(String profile) {
        this(Builder.getBackend(), profile);
    }

    public TracendpointInterceptor(Backend backend, String profile) {
        super(backend, profile);
    }

    public boolean handleRequest(MessageContext messageContext, Object o) {
        this.parseContextFromSoapHeader(messageContext.getRequest(), TraceFilterConfiguration.Channel.IncomingRequest);
        Builder.generateInvocationIdIfNecessary(this.backend);
        return true;
    }

    public boolean handleResponse(MessageContext messageContext, Object o) {
        this.serializeContextToSoapHeader(messageContext.getResponse(), TraceFilterConfiguration.Channel.OutgoingResponse);
        return true;
    }

    public boolean handleFault(MessageContext messageContext, Object o) {
        return this.handleResponse(messageContext, o);
    }

    public void afterCompletion(MessageContext messageContext, Object o, Exception e) {
        this.backend.clear();
    }
}

