/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.transport;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.soap.SOAPHeader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.tracer.transport.jaxb.TpicMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SoapHeaderTransport {
    private static final SOAPHeaderMarshaller SOAP_HEADER_MARSHALLER = new SOAPHeaderMarshaller();
    private static final ResultMarshaller RESULT_MARSHALLER = new ResultMarshaller();
    private static final ElementUnmarshaller ELEMENT_UNMARSHALLER = new ElementUnmarshaller();
    private static final SourceUnmarshaller SOURCE_UNMARSHALLER = new SourceUnmarshaller();
    private final JAXBContext jaxbContext;

    public SoapHeaderTransport() {
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{TpicMap.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, String> parseSoapHeader(Element soapHeader) {
        NodeList tpicHeaders = soapHeader.getElementsByTagNameNS("http://Trace.io/tpic/1.0", "TPIC");
        HashMap<String, String> contextMap = new HashMap<String, String>();
        if (tpicHeaders != null && tpicHeaders.getLength() > 0) {
            int items = tpicHeaders.getLength();
            for (int i = 0; i < items; ++i) {
                contextMap.putAll(this.parseTpicHeader((Element)tpicHeaders.item(i)));
            }
        }
        return contextMap;
    }

    public Map<String, String> parseTpicHeader(Element element) {
        return this.parseTpicHeader(ELEMENT_UNMARSHALLER, element);
    }

    public Map<String, String> parseTpicHeader(Source source) {
        return this.parseTpicHeader(SOURCE_UNMARSHALLER, source);
    }

    private <T> Map<String, String> parseTpicHeader(Unmarshallable<T> unmarshallable, T xmlContext) {
        try {
            Unmarshaller unmarshaller;
            JAXBElement<TpicMap> unmarshal;
            if (xmlContext != null && (unmarshal = unmarshallable.unmarshal(unmarshaller = this.jaxbContext.createUnmarshaller(), xmlContext)) != null) {
                return ((TpicMap)unmarshal.getValue()).unwrapValues();
            }
        }
        catch (JAXBException e) {
            Logger.warn("Unable to parse TPIC header: {}", e.getMessage());
            Logger.debug("WithStack: Unable to parse TPIC header: {}", new Object[]{e.getMessage(), e});
        }
        return new HashMap<String, String>();
    }

    public void renderSoapHeader(Map<String, String> context, SOAPHeader soapHeader) {
        this.renderSoapHeader(SOAP_HEADER_MARSHALLER, context, soapHeader);
    }

    public void renderSoapHeader(Map<String, String> context, Result result) {
        this.renderSoapHeader(RESULT_MARSHALLER, context, result);
    }

    private <T> void renderSoapHeader(Marshallable<T> marshallable, Map<String, String> context, T xmlContext) {
        try {
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            marshallable.marshal(marshaller, TpicMap.wrap(context), xmlContext);
        }
        catch (JAXBException e) {
            Logger.warn("Unable to render TPIC header: {}", e.getMessage());
            Logger.debug("WithStack: Unable to render TPIC header: {}", new Object[]{e.getMessage(), e});
        }
    }

    private static class SOAPHeaderMarshaller
    implements Marshallable<SOAPHeader> {
        private SOAPHeaderMarshaller() {
        }

        @Override
        public void marshal(Marshaller marshaller, TpicMap tpic, SOAPHeader soapHeader) throws JAXBException {
            marshaller.marshal((Object)tpic, (Node)soapHeader);
        }
    }

    private static class ResultMarshaller
    implements Marshallable<Result> {
        private ResultMarshaller() {
        }

        @Override
        public void marshal(Marshaller marshaller, TpicMap tpic, Result result) throws JAXBException {
            marshaller.marshal((Object)tpic, result);
        }
    }

    private static class ElementUnmarshaller
    implements Unmarshallable<Element> {
        private ElementUnmarshaller() {
        }

        @Override
        public JAXBElement<TpicMap> unmarshal(Unmarshaller unmarshaller, Element element) throws JAXBException {
            return unmarshaller.unmarshal((Node)element, TpicMap.class);
        }
    }

    private static class SourceUnmarshaller
    implements Unmarshallable<Source> {
        private SourceUnmarshaller() {
        }

        @Override
        public JAXBElement<TpicMap> unmarshal(Unmarshaller unmarshaller, Source source) throws JAXBException {
            return unmarshaller.unmarshal(source, TpicMap.class);
        }
    }

    private static interface Marshallable<T> {
        public void marshal(Marshaller var1, TpicMap var2, T var3) throws JAXBException;
    }

    private static interface Unmarshallable<T> {
        public JAXBElement<TpicMap> unmarshal(Unmarshaller var1, T var2) throws JAXBException;
    }
}

