/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.binding.jaxws;

import java.util.Map;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.aoju.bus.tracer.Backend;
import org.aoju.bus.tracer.Builder;
import org.aoju.bus.tracer.binding.jaxws.AbstractTraceHandler;
import org.aoju.bus.tracer.config.TraceFilterConfiguration;
import org.aoju.bus.tracer.transport.SoapHeaderTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class TraceServerHandler
extends AbstractTraceHandler {
    private static final Logger logger = LoggerFactory.getLogger(TraceServerHandler.class);
    private final SoapHeaderTransport transportSerialization;

    public TraceServerHandler() {
        this(Builder.getBackend(), new SoapHeaderTransport());
    }

    public TraceServerHandler(Backend Backend2, SoapHeaderTransport soapHeaderTransport) {
        super(Backend2);
        this.transportSerialization = soapHeaderTransport;
    }

    @Override
    protected final void handleIncoming(SOAPMessageContext context) {
        SOAPMessage soapMessage = context.getMessage();
        try {
            SOAPHeader header = soapMessage.getSOAPHeader();
            if (header != null && this.Backend.getConfiguration().shouldProcessContext(TraceFilterConfiguration.Channel.IncomingRequest)) {
                Map<String, String> parsedContext = this.transportSerialization.parseSoapHeader((Element)header);
                Map<String, String> filteredContext = this.Backend.getConfiguration().filterDeniedParams(parsedContext, TraceFilterConfiguration.Channel.IncomingRequest);
                this.Backend.putAll(filteredContext);
            }
        }
        catch (SOAPException e) {
            logger.warn("Error during precessing of inbound soap header: {}", (Object)e.getMessage());
            logger.debug("Detailed: Error during precessing of inbound soap header: {}", (Object)e.getMessage(), (Object)e);
        }
        Builder.generateInvocationIdIfNecessary(this.Backend);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void handleOutgoing(SOAPMessageContext context) {
        SOAPMessage msg = context.getMessage();
        try {
            if (msg != null && !this.Backend.isEmpty() && this.Backend.getConfiguration().shouldProcessContext(TraceFilterConfiguration.Channel.OutgoingResponse)) {
                SOAPHeader header = this.getOrCreateHeader(msg);
                Map<String, String> filteredContext = this.Backend.getConfiguration().filterDeniedParams(this.Backend.copyToMap(), TraceFilterConfiguration.Channel.OutgoingResponse);
                this.transportSerialization.renderSoapHeader(filteredContext, header);
                msg.saveChanges();
                context.setMessage(msg);
            }
        }
        catch (SOAPException e) {
            logger.error("TraceServerHandler : Exception occurred during processing of outbound message.");
            logger.debug("Detailed: TraceServerHandler : Exception occurred during processing of outbound message: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            this.Backend.clear();
        }
    }

    public boolean handleFault(SOAPMessageContext context) {
        this.handleOutgoing(context);
        return true;
    }
}

