/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.binding.spring.http;

import org.aoju.bus.tracer.Backend;
import org.aoju.bus.tracer.binding.spring.http.TraceClientHttpRequestInterceptor;
import org.aoju.bus.tracer.transport.HttpHeaderTransport;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.web.client.RestTemplate;

@Configuration
public class TraceSpringWebConfiguration {
    @Role(value=2)
    @Bean
    TraceClientHttpRequestInterceptor TraceClientHttpRequestInterceptor(Backend Backend2) {
        return new TraceClientHttpRequestInterceptor(Backend2, new HttpHeaderTransport(), "default");
    }

    @Role(value=2)
    @Bean
    BeanPostProcessor restTemplatePostProcessor(TraceClientHttpRequestInterceptor TraceClientHttpRequestInterceptor2) {
        return new RestTemplatePostProcessor(TraceClientHttpRequestInterceptor2);
    }

    private static class RestTemplatePostProcessor
    implements BeanPostProcessor {
        private final TraceClientHttpRequestInterceptor interceptor;

        private RestTemplatePostProcessor(TraceClientHttpRequestInterceptor interceptor) {
            this.interceptor = interceptor;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof RestTemplate) {
                ((RestTemplate)bean).getInterceptors().add(this.interceptor);
            }
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }
    }
}

