/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.limiter.intercept;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.limiter.execute.LimitContextsValueWrapper;
import org.aoju.bus.limiter.execute.LimiterExecutionContext;
import org.aoju.bus.limiter.metadata.LimitedResourceMetadata;
import org.aoju.bus.limiter.metadata.LimitedResourceMetadataCache;
import org.aoju.bus.limiter.resource.LimitedResource;
import org.aoju.bus.limiter.source.LimitedResourceSource;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.SmartInitializingSingleton;

public abstract class LimiterAspectSupport
implements BeanFactoryAware,
InitializingBean,
SmartInitializingSingleton {
    private BeanFactory beanFactory;
    private boolean initialized = false;
    private LimitedResourceSource limitedResourceSource;
    private LimitedResourceMetadataCache limitedResourceMetadataCache;

    protected Object execute(MethodInvocation invocation, Object target, Method method, Object[] args) throws Throwable {
        if (this.initialized) {
            Collection<LimitedResource> limitedResources;
            Class targetClass = AopProxyUtils.ultimateTargetClass((Object)target);
            LimitedResourceSource limitedResourceSource = this.getLimitedResourceSource();
            if (limitedResourceSource != null && !CollUtils.isEmpty(limitedResources = limitedResourceSource.getLimitedResource(targetClass, method))) {
                Collection<LimiterExecutionContext> contexts = this.getLimiterOperationContexts(limitedResources, method, args, target, targetClass);
                LimitContextsValueWrapper limitContextsValueWrapper = this.limitContexts(contexts);
                if (limitContextsValueWrapper.value()) {
                    try {
                        Object object = invocation.proceed();
                        return object;
                    }
                    catch (Throwable e) {
                        throw e;
                    }
                    finally {
                        this.releaseContexts(contexts);
                    }
                }
                return limitContextsValueWrapper.getLimiterFailResolveResult();
            }
        }
        return invocation.proceed();
    }

    public void afterSingletonsInstantiated() {
        this.initialized = true;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        this.limitedResourceMetadataCache = new LimitedResourceMetadataCache(beanFactory);
    }

    protected LimitContextsValueWrapper limitContexts(Collection<LimiterExecutionContext> contexts) {
        ArrayList<LimiterExecutionContext> limited = new ArrayList<LimiterExecutionContext>();
        for (LimiterExecutionContext context : contexts) {
            if (context.limit() && context.getThrowable() == null) {
                limited.add(context);
                continue;
            }
            this.releaseContexts(limited);
            Object result = context.getFallbackResult();
            return new LimitContextsValueWrapper(false, result);
        }
        return new LimitContextsValueWrapper(true, null);
    }

    protected void releaseContexts(Collection<LimiterExecutionContext> contexts) {
        if (contexts != null && !contexts.isEmpty()) {
            for (LimiterExecutionContext context : contexts) {
                context.release();
            }
        }
    }

    protected Collection<LimiterExecutionContext> getLimiterOperationContexts(Collection<LimitedResource> limitedResources, Method method, Object[] args, Object target, Class<?> targetClass) {
        ArrayList<LimiterExecutionContext> retVal = new ArrayList<LimiterExecutionContext>();
        for (LimitedResource limitedResource : limitedResources) {
            LimitedResourceMetadata metadata = this.limitedResourceMetadataCache.getLimitedResourceMetadata(limitedResource, method, targetClass);
            retVal.add(new LimiterExecutionContext(metadata, args, target, this.beanFactory));
        }
        return retVal;
    }

    public LimitedResourceSource getLimitedResourceSource() {
        return this.limitedResourceSource;
    }

    public void setLimitedResourceSource(LimitedResourceSource limitedResourceSource) {
        this.limitedResourceSource = limitedResourceSource;
    }

    public void afterPropertiesSet() throws Exception {
    }
}

