/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.binding.jaxrs2;

import java.util.List;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;
import org.aoju.bus.tracer.Backend;
import org.aoju.bus.tracer.Builder;
import org.aoju.bus.tracer.config.TraceFilterConfiguration;
import org.aoju.bus.tracer.transport.HttpHeaderTransport;

@Provider
public class TraceContainerFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private final Backend backend;
    private final HttpHeaderTransport transportSerialization;

    public TraceContainerFilter() {
        this(Builder.getBackend());
    }

    TraceContainerFilter(Backend backend) {
        this.backend = backend;
        this.transportSerialization = new HttpHeaderTransport();
    }

    public void filter(ContainerRequestContext containerRequestContext) {
        List serializedTraceHeaders;
        if (this.backend.getConfiguration().shouldProcessContext(TraceFilterConfiguration.Channel.IncomingRequest) && (serializedTraceHeaders = (List)containerRequestContext.getHeaders().get((Object)"TPIC")) != null && !serializedTraceHeaders.isEmpty()) {
            Map<String, String> parsed = this.transportSerialization.parse(serializedTraceHeaders);
            this.backend.putAll(this.backend.getConfiguration().filterDeniedParams(parsed, TraceFilterConfiguration.Channel.IncomingRequest));
        }
        Builder.generateInvocationIdIfNecessary(this.backend);
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        if (this.backend.getConfiguration().shouldProcessContext(TraceFilterConfiguration.Channel.OutgoingResponse)) {
            Map<String, String> filtered = this.backend.getConfiguration().filterDeniedParams(this.backend.copyToMap(), TraceFilterConfiguration.Channel.OutgoingResponse);
            responseContext.getHeaders().putSingle((Object)"TPIC", (Object)this.transportSerialization.render(filtered));
        }
        this.backend.clear();
    }
}

