/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.resource;

import java.io.BufferedReader;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import org.aoju.bus.core.io.resource.Resource;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.IoUtils;

public class InputStreamResource
implements Resource {
    private InputStream in;
    private String name;

    public InputStreamResource(InputStream in) {
        this(in, null);
    }

    public InputStreamResource(InputStream in, String name) {
        this.in = in;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getUrl() {
        return null;
    }

    @Override
    public InputStream getStream() {
        return this.in;
    }

    @Override
    public BufferedReader getReader(Charset charset) {
        return IoUtils.getReader(this.in, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readStr(Charset charset) throws InstrumentException {
        BufferedReader reader = null;
        try {
            reader = this.getReader(charset);
            String string = IoUtils.read(reader);
            return string;
        }
        finally {
            IoUtils.close(reader);
        }
    }

    @Override
    public String readUtf8Str() throws InstrumentException {
        return this.readStr(org.aoju.bus.core.consts.Charset.UTF_8);
    }

    @Override
    public byte[] readBytes() throws InstrumentException {
        InputStream in = null;
        try {
            in = this.getStream();
            byte[] byArray = IoUtils.readBytes(in);
            return byArray;
        }
        finally {
            IoUtils.close(in);
        }
    }
}

