/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring.sensitive;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.crypto.CryptoUtils;
import org.aoju.bus.sensitive.Builder;
import org.aoju.bus.sensitive.Provider;
import org.aoju.bus.sensitive.annotation.Privacy;
import org.aoju.bus.sensitive.annotation.Sensitive;
import org.aoju.bus.spring.crypto.CryptoProperties;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.springframework.beans.factory.annotation.Autowired;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class SensitiveResultSetHandler
implements Interceptor {
    private static final String MAPPED_STATEMENT = "mappedStatement";
    @Autowired
    CryptoProperties cryptoProperties;

    public Object intercept(Invocation invocation) throws Throwable {
        List results = (List)invocation.proceed();
        if (results.isEmpty()) {
            return results;
        }
        ResultSetHandler statementHandler = (ResultSetHandler)Provider.realTarget(invocation.getTarget());
        MetaObject metaObject = SystemMetaObject.forObject((Object)statementHandler);
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue(MAPPED_STATEMENT);
        ResultMap resultMap = mappedStatement.getResultMaps().isEmpty() ? null : (ResultMap)mappedStatement.getResultMaps().get(0);
        Object result0 = results.get(0);
        Sensitive enableSensitive = result0.getClass().getAnnotation(Sensitive.class);
        if (enableSensitive == null) {
            return results;
        }
        Map<String, Privacy> sensitiveFieldMap = this.getSensitiveByResultMap(resultMap);
        Map<String, org.aoju.bus.sensitive.annotation.Field> sensitiveBindedMap = this.getSensitiveBindedByResultMap(resultMap);
        if (sensitiveBindedMap.isEmpty() && sensitiveFieldMap.isEmpty()) {
            return results;
        }
        for (Object obj : results) {
            String property;
            MetaObject objMetaObject = mappedStatement.getConfiguration().newMetaObject(obj);
            for (Map.Entry<String, Privacy> entry : sensitiveFieldMap.entrySet()) {
                property = entry.getKey();
                String value = (String)objMetaObject.getValue(property);
                if (value == null) continue;
                String decryptValue = new String(CryptoUtils.decrypt(this.cryptoProperties.getDecrypt().getType(), this.cryptoProperties.getDecrypt().getKey(), Base64.decode(value)), "UTF-8");
                objMetaObject.setValue(property, (Object)decryptValue);
            }
            for (Map.Entry<String, Annotation> entry : sensitiveBindedMap.entrySet()) {
                property = entry.getKey();
                org.aoju.bus.sensitive.annotation.Field sensitiveBind = (org.aoju.bus.sensitive.annotation.Field)entry.getValue();
                String bindPropety = sensitiveBind.field();
                Builder.Type sensitiveType = sensitiveBind.type();
                try {
                    String value = (String)objMetaObject.getValue(bindPropety);
                    String resultValue = (String)Builder.on((Object)sensitiveType);
                    objMetaObject.setValue(property, (Object)resultValue);
                }
                catch (Exception exception) {}
            }
        }
        return results;
    }

    private Map<String, org.aoju.bus.sensitive.annotation.Field> getSensitiveBindedByResultMap(ResultMap resultMap) {
        if (resultMap == null) {
            return new HashMap<String, org.aoju.bus.sensitive.annotation.Field>(16);
        }
        HashMap<String, org.aoju.bus.sensitive.annotation.Field> sensitiveBindedMap = new HashMap<String, org.aoju.bus.sensitive.annotation.Field>(16);
        Class clazz = resultMap.getType();
        for (Field field : clazz.getDeclaredFields()) {
            org.aoju.bus.sensitive.annotation.Field sensitiveBind = field.getAnnotation(org.aoju.bus.sensitive.annotation.Field.class);
            if (sensitiveBind == null) continue;
            sensitiveBindedMap.put(field.getName(), sensitiveBind);
        }
        return sensitiveBindedMap;
    }

    private Map<String, Privacy> getSensitiveByResultMap(ResultMap resultMap) {
        if (resultMap == null) {
            return new HashMap<String, Privacy>(16);
        }
        return this.getSensitiveByType(resultMap.getType());
    }

    private Map<String, Privacy> getSensitiveByType(Class<?> clazz) {
        HashMap<String, Privacy> sensitiveFieldMap = new HashMap<String, Privacy>(16);
        for (Field field : clazz.getDeclaredFields()) {
            Privacy sensitiveField = field.getAnnotation(Privacy.class);
            if (sensitiveField == null) continue;
            sensitiveFieldMap.put(field.getName(), sensitiveField);
        }
        return sensitiveFieldMap;
    }

    public Object plugin(Object o) {
        return Plugin.wrap((Object)o, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

