/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.List;
import org.aoju.bus.core.io.resource.ClassPathResource;
import org.aoju.bus.core.io.resource.FileResource;
import org.aoju.bus.core.io.resource.Resource;
import org.aoju.bus.core.lang.exception.CommonException;
import org.aoju.bus.core.utils.ClassUtils;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.core.utils.FileUtils;
import org.aoju.bus.core.utils.IterUtils;

public class ResourceUtils {
    public static String readUtf8Str(String resource) {
        return new ClassPathResource(resource).readUtf8Str();
    }

    public static String readStr(String resource, Charset charset) {
        return new ClassPathResource(resource).readStr(charset);
    }

    public static InputStream getStream(String resurce) throws CommonException {
        return new ClassPathResource(resurce).getStream();
    }

    public static InputStream getStreamSafe(String resurce) {
        try {
            return new ClassPathResource(resurce).getStream();
        }
        catch (CommonException commonException) {
            return null;
        }
    }

    public static BufferedReader getReader(String resurce, Charset charset) {
        return new ClassPathResource(resurce).getReader(charset);
    }

    public static URL getResource(String resource) throws CommonException {
        return ResourceUtils.getResource(resource, null);
    }

    public static List<URL> getResources(String resource) {
        Enumeration<URL> resources;
        try {
            resources = ClassUtils.getClassLoader().getResources(resource);
        }
        catch (IOException e) {
            throw new CommonException(e);
        }
        return CollUtils.newArrayList(resources);
    }

    public static IterUtils.EnumerationIter<URL> getResourceIter(String resource) {
        Enumeration<URL> resources;
        try {
            resources = ClassUtils.getClassLoader().getResources(resource);
        }
        catch (IOException e) {
            throw new CommonException(e);
        }
        return new IterUtils.EnumerationIter<URL>(resources);
    }

    public static URL getResource(String resource, Class<?> baseClass) {
        return null != baseClass ? baseClass.getResource(resource) : ClassUtils.getClassLoader().getResource(resource);
    }

    public static Resource getResourceObj(String path) {
        return FileUtils.isAbsolutePath(path) ? new FileResource(path) : new ClassPathResource(path);
    }
}

