/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class BodyCacheHttpServletResponseWrapper
extends HttpServletResponseWrapper {
    private ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private PrintWriter writer = new PrintWriter(this.byteArrayOutputStream);

    BodyCacheHttpServletResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public byte[] getBody() {
        return this.byteArrayOutputStream.toByteArray();
    }

    public ServletOutputStream getOutputStream() {
        return new ServletOutputStream(){

            public boolean isReady() {
                return false;
            }

            public void setWriteListener(WriteListener writeListener) {
            }

            public void write(int b) throws IOException {
                TeeOutputStream write = new TeeOutputStream((OutputStream)BodyCacheHttpServletResponseWrapper.super.getOutputStream(), BodyCacheHttpServletResponseWrapper.this.byteArrayOutputStream);
                write.write(b);
            }
        };
    }

    public PrintWriter getWriter() throws IOException {
        return new ServletPrintWriter(super.getWriter(), this.writer);
    }

    class TeeOutputStream
    extends OutputStream {
        private OutputStream output1;
        private OutputStream output2;

        public TeeOutputStream(OutputStream output1, OutputStream output2) {
            this.output1 = output1;
            this.output2 = output2;
        }

        @Override
        public void write(byte[] buf) throws IOException {
            this.output1.write(buf);
            this.output2.write(buf);
        }

        @Override
        public void write(byte[] buf, int off, int len) throws IOException {
            this.output1.write(buf, off, len);
            this.output2.write(buf, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.output1.write(b);
            this.output2.write(b);
        }

        @Override
        public void flush() throws IOException {
            this.output1.flush();
            this.output2.flush();
        }

        @Override
        public void close() throws IOException {
            this.output1.close();
            this.output2.close();
        }
    }

    private static class ServletPrintWriter
    extends PrintWriter {
        PrintWriter printWriter;

        ServletPrintWriter(PrintWriter main, PrintWriter printWriter) {
            super((Writer)main, true);
            this.printWriter = printWriter;
        }

        @Override
        public void write(char[] buff, int off, int len) {
            super.write(buff, off, len);
            super.flush();
            this.printWriter.write(buff, off, len);
            this.printWriter.flush();
        }

        @Override
        public void write(String s, int off, int len) {
            super.write(s, off, len);
            super.flush();
            this.printWriter.write(s, off, len);
            this.printWriter.flush();
        }

        @Override
        public void write(int c) {
            super.write(c);
            super.flush();
            this.printWriter.write(c);
            this.printWriter.flush();
        }

        @Override
        public void flush() {
            super.flush();
            this.printWriter.flush();
        }
    }
}

