/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.storage.provider.qiniu;

import com.qiniu.common.QiniuException;
import com.qiniu.common.Zone;
import com.qiniu.http.Response;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import com.qiniu.util.StringMap;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.MapUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.storage.Provider;
import org.aoju.bus.storage.UploadObject;
import org.aoju.bus.storage.UploadToken;
import org.aoju.bus.storage.provider.AbstractProvider;

public class QiniuOSSProvider
extends AbstractProvider {
    private static final String DEFAULT_CALLBACK_BODY = "filename=${fname}&size=${fsize}&mimeType=${mimeType}&height=${imageInfo.height}&width=${imageInfo.width}";
    private static final String[] policyFields = new String[]{"callbackUrl", "callbackBody", "callbackHost", "callbackBodyType", "fileType", "saveKey", "mimeLimit", "fsizeLimit", "fsizeMin", "deleteAfterDays"};
    private static UploadManager uploadManager;
    private static BucketManager bucketManager;
    private Auth auth;
    private String host;

    public QiniuOSSProvider(String prefix, String bucket, String accessKey, String secretKey, boolean privated) {
        Assert.notBlank(bucket, "[bucket] not defined", new Object[0]);
        Assert.notBlank(accessKey, "[accessKey] not defined", new Object[0]);
        Assert.notBlank(secretKey, "[secretKey] not defined", new Object[0]);
        Assert.notBlank(prefix, "[urlprefix] not defined", new Object[0]);
        this.prefix = prefix.endsWith("/") ? prefix : prefix + "/";
        this.bucket = bucket;
        this.auth = Auth.create((String)accessKey, (String)secretKey);
        Zone z = Zone.autoZone();
        Configuration c = new Configuration(z);
        uploadManager = new UploadManager(c);
        bucketManager = new BucketManager(this.auth, c);
        this.privated = privated;
        this.host = StringUtils.remove(prefix, "/").split(":")[1];
    }

    @Override
    public String upload(UploadObject object) {
        String fileName = object.getFileName();
        if (StringUtils.isNotBlank(object.getCatalog())) {
            fileName = object.getCatalog().concat("/").concat(fileName);
        }
        try {
            Response res;
            String upToken = this.getUpToken();
            if (object.getFile() != null) {
                res = uploadManager.put(object.getFile(), fileName, upToken);
            } else if (object.getBytes() != null) {
                res = uploadManager.put(object.getBytes(), fileName, upToken);
            } else if (object.getInputStream() != null) {
                res = uploadManager.put(object.getInputStream(), fileName, upToken, null, object.getMimeType());
            } else {
                if (StringUtils.isNotBlank(object.getUrl())) {
                    return QiniuOSSProvider.bucketManager.fetch((String)object.getUrl(), (String)this.bucket, (String)fileName).key;
                }
                throw new IllegalArgumentException("upload object is NULL");
            }
            return this.processUploadResponse(res);
        }
        catch (QiniuException e) {
            throw new InstrumentException(e);
        }
    }

    @Override
    public String getUrl(String fileKey, boolean isInternal) {
        String path = this.getFullPath(fileKey);
        if (this.privated) {
            path = this.auth.privateDownloadUrl(path, 3600L);
        }
        return path;
    }

    @Override
    public boolean delete(String fileKey) {
        try {
            if (fileKey.contains("/")) {
                fileKey = fileKey.replace(this.prefix, "");
            }
            bucketManager.delete(this.bucket, fileKey);
            return true;
        }
        catch (QiniuException e) {
            throw new InstrumentException(e);
        }
    }

    @Override
    public Map<String, Object> createUploadToken(UploadToken param) {
        if (StringUtils.isNotBlank(param.getCallbackUrl())) {
            if (StringUtils.isBlank(param.getCallbackBody())) {
                param.setCallbackBody(DEFAULT_CALLBACK_BODY);
            }
            if (StringUtils.isBlank(param.getCallbackHost())) {
                param.setCallbackHost(this.host);
            }
        }
        HashMap<String, Object> result = MapUtils.newHashMap();
        StringMap policy = new StringMap();
        policy.putNotNull(policyFields[0], (Object)param.getCallbackUrl());
        policy.putNotNull(policyFields[1], (Object)param.getCallbackBody());
        policy.putNotNull(policyFields[2], (Object)param.getCallbackHost());
        policy.putNotNull(policyFields[3], (Object)param.getCallbackBodyType());
        policy.putNotNull(policyFields[4], (Object)param.getFileType());
        policy.putNotNull(policyFields[5], (Object)param.getFileKey());
        policy.putNotNull(policyFields[6], (Object)param.getMimeLimit());
        policy.putNotNull(policyFields[7], (Object)param.getFsizeMin());
        policy.putNotNull(policyFields[8], (Object)param.getFsizeMax());
        policy.putNotNull(policyFields[9], (Object)param.getDeleteAfterDays());
        String token = this.auth.uploadToken(this.bucket, param.getFileKey(), param.getExpires(), policy, true);
        result.put("uptoken", token);
        result.put("host", this.prefix);
        result.put("dir", param.getUploadDir());
        return result;
    }

    @Override
    public void close() {
    }

    @Override
    public String name() {
        return Provider.QINIU_OSS.getValue();
    }

    private String processUploadResponse(Response res) throws QiniuException {
        if (res.isOK()) {
            UploadResult ret = (UploadResult)res.jsonToObject(UploadResult.class);
            return this.getFullPath(ret.getKey());
        }
        throw new InstrumentException(res.toString());
    }

    private String getUpToken() {
        return this.auth.uploadToken(this.bucket);
    }

    class UploadResult {
        private long fsize;
        private String key;
        private String hash;
        private int width;
        private int height;

        public long getFsize() {
            return this.fsize;
        }

        public String getKey() {
            return this.key;
        }

        public String getHash() {
            return this.hash;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setFsize(long fsize) {
            this.fsize = fsize;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setHash(String hash) {
            this.hash = hash;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UploadResult)) {
                return false;
            }
            UploadResult other = (UploadResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getFsize() != other.getFsize()) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$hash = this.getHash();
            String other$hash = other.getHash();
            if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
                return false;
            }
            if (this.getWidth() != other.getWidth()) {
                return false;
            }
            return this.getHeight() == other.getHeight();
        }

        protected boolean canEqual(Object other) {
            return other instanceof UploadResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $fsize = this.getFsize();
            result = result * 59 + (int)($fsize >>> 32 ^ $fsize);
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $hash = this.getHash();
            result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
            result = result * 59 + this.getWidth();
            result = result * 59 + this.getHeight();
            return result;
        }

        public String toString() {
            return "QiniuOSSProvider.UploadResult(fsize=" + this.getFsize() + ", key=" + this.getKey() + ", hash=" + this.getHash() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ")";
        }
    }
}

