/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.validate;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aoju.bus.core.lang.exception.ValidateException;
import org.aoju.bus.core.utils.ObjectUtils;
import org.aoju.bus.validate.strategy.AlwaysStrategy;
import org.aoju.bus.validate.strategy.BlankStrategy;
import org.aoju.bus.validate.strategy.EachStrategy;
import org.aoju.bus.validate.strategy.EqualsStrategy;
import org.aoju.bus.validate.strategy.FalseStrategy;
import org.aoju.bus.validate.strategy.InEnumStrategy;
import org.aoju.bus.validate.strategy.InStrategy;
import org.aoju.bus.validate.strategy.IntRangeStrategy;
import org.aoju.bus.validate.strategy.LengthStrategy;
import org.aoju.bus.validate.strategy.MultiStrategy;
import org.aoju.bus.validate.strategy.NotBlankStrategy;
import org.aoju.bus.validate.strategy.NotInStrategy;
import org.aoju.bus.validate.strategy.NotNullStrategy;
import org.aoju.bus.validate.strategy.NullStrategy;
import org.aoju.bus.validate.strategy.ReflectStrategy;
import org.aoju.bus.validate.strategy.RegexStrategy;
import org.aoju.bus.validate.strategy.TrueStrategy;

public class Registry {
    private static Map<Object, Object> COMPLEX_CACHE = new ConcurrentHashMap<Object, Object>();
    private static Registry instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Registry getInstance() {
        Class<Registry> clazz = Registry.class;
        synchronized (Registry.class) {
            if (instance == null) {
                instance = new Registry();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void register(String name, Object objet) {
        if (COMPLEX_CACHE.containsKey(name)) {
            throw new ValidateException("\u91cd\u590d\u6ce8\u518c\u540c\u540d\u79f0\u7684\u6821\u9a8c\u5668\uff1a" + name);
        }
        Class<?> clazz = objet.getClass();
        if (COMPLEX_CACHE.containsKey(clazz.getSimpleName())) {
            throw new ValidateException("\u91cd\u590d\u6ce8\u518c\u540c\u7c7b\u578b\u7684\u6821\u9a8c\u5668\uff1a" + clazz);
        }
        COMPLEX_CACHE.putIfAbsent(name, objet);
        COMPLEX_CACHE.putIfAbsent(clazz.getSimpleName(), objet);
    }

    public boolean contains(String name) {
        return COMPLEX_CACHE.containsKey(name);
    }

    public Object get(String name) {
        return COMPLEX_CACHE.get(name);
    }

    public Object get(String name, Class<?> clazz) {
        Object object = this.get(name);
        if (ObjectUtils.isEmpty(object)) {
            object = this.get(clazz.getSimpleName());
        }
        return object;
    }

    static {
        Registry.register("Blank", new BlankStrategy());
        Registry.register("Each", new EachStrategy());
        Registry.register("Equals", new EqualsStrategy());
        Registry.register("False", new FalseStrategy());
        Registry.register("In", new InStrategy());
        Registry.register("InEnum", new InEnumStrategy());
        Registry.register("IntRange", new IntRangeStrategy());
        Registry.register("Length", new LengthStrategy());
        Registry.register("Multi", new MultiStrategy());
        Registry.register("NotBlank", new NotBlankStrategy());
        Registry.register("NotIn", new NotInStrategy());
        Registry.register("NotNull", new NotNullStrategy());
        Registry.register("Null", new NullStrategy());
        Registry.register("Reflect", new ReflectStrategy());
        Registry.register("Regex", new RegexStrategy());
        Registry.register("True", new TrueStrategy());
        Registry.register("Always", new AlwaysStrategy());
    }
}

