/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cache.support.cache;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import javax.annotation.PreDestroy;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.exception.MemcachedException;
import org.aoju.bus.cache.support.cache.Cache;
import org.aoju.bus.cache.support.serialize.BaseSerializer;
import org.aoju.bus.cache.support.serialize.Hessian2Serializer;

public class MemcachedCache
implements Cache {
    private static final int _30_DAYS = 2592000;
    private MemcachedClient client;
    private BaseSerializer serializer;

    public MemcachedCache(String ipPorts) throws IOException {
        this(ipPorts, new Hessian2Serializer());
    }

    public MemcachedCache(String addressList, BaseSerializer serializer) throws IOException {
        this.client = new XMemcachedClientBuilder(addressList).build();
        this.serializer = serializer;
    }

    @Override
    public Object read(String key) {
        try {
            byte[] bytes = (byte[])this.client.get(key);
            return this.serializer.deserialize(bytes);
        }
        catch (InterruptedException | TimeoutException | MemcachedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void write(String key, Object value, long expire) {
        byte[] byteValue = this.serializer.serialize(value);
        try {
            if (expire == 0L) {
                this.client.set(key, 2592000, (Object)byteValue);
            } else {
                this.client.set(key, (int)(expire / 1000L), (Object)byteValue);
            }
        }
        catch (InterruptedException | TimeoutException | MemcachedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, Object> read(Collection<String> keys) {
        try {
            Map byteMap = this.client.get(keys);
            HashMap<String, Object> resultMap = new HashMap<String, Object>(byteMap.size());
            for (Map.Entry entry : byteMap.entrySet()) {
                String key = (String)entry.getKey();
                Object value = this.serializer.deserialize((byte[])entry.getValue());
                resultMap.put(key, value);
            }
            return resultMap;
        }
        catch (InterruptedException | TimeoutException | MemcachedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void write(Map<String, Object> keyValueMap, long expire) {
        for (Map.Entry<String, Object> entry : keyValueMap.entrySet()) {
            this.write(entry.getKey(), entry.getValue(), expire);
        }
    }

    @Override
    public void remove(String ... keys) {
        try {
            for (String key : keys) {
                this.client.delete(key);
            }
        }
        catch (InterruptedException | TimeoutException | MemcachedException e) {
            throw new RuntimeException(e);
        }
    }

    @PreDestroy
    public void tearDown() {
        if (this.client != null && !this.client.isShutdown()) {
            try {
                this.client.shutdown();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

