/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.date;

import java.util.Calendar;
import java.util.Date;
import org.aoju.bus.core.consts.Fields;
import org.aoju.bus.core.utils.DateUtils;

public class Between {
    private Date begin;
    private Date end;

    public Between(Date begin, Date end) {
        this(begin, end, true);
    }

    public Between(Date begin, Date end, boolean isAbs) {
        if (isAbs && begin.after(end)) {
            this.begin = end;
            this.end = begin;
        } else {
            this.begin = begin;
            this.end = end;
        }
    }

    public static Between create(Date begin, Date end) {
        return new Between(begin, end);
    }

    public static Between create(Date begin, Date end, boolean isAbs) {
        return new Between(begin, end, isAbs);
    }

    public long between(Fields.Unit unit) {
        long diff = this.end.getTime() - this.begin.getTime();
        return diff / unit.getMillis();
    }

    public long betweenMonth(boolean isReset) {
        Calendar beginCal = DateUtils.calendar(this.begin);
        Calendar endCal = DateUtils.calendar(this.end);
        int betweenYear = endCal.get(1) - beginCal.get(1);
        int betweenMonthOfYear = endCal.get(2) - beginCal.get(2);
        int result = betweenYear * 12 + betweenMonthOfYear;
        if (!isReset) {
            endCal.set(1, beginCal.get(1));
            endCal.set(2, beginCal.get(2));
            long between = endCal.getTimeInMillis() - beginCal.getTimeInMillis();
            if (between < 0L) {
                return result - 1;
            }
        }
        return result;
    }

    public long betweenYear(boolean isReset) {
        Calendar beginCal = DateUtils.calendar(this.begin);
        Calendar endCal = DateUtils.calendar(this.end);
        int result = endCal.get(1) - beginCal.get(1);
        if (!isReset) {
            endCal.set(1, beginCal.get(1));
            long between = endCal.getTimeInMillis() - beginCal.getTimeInMillis();
            if (between < 0L) {
                return result - 1;
            }
        }
        return result;
    }

    public String toString(Fields.Level level) {
        return DateUtils.formatBetween(this.between(Fields.Unit.MS), level);
    }

    public String toString() {
        return this.toString(Fields.Level.MILLSECOND);
    }
}

