/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.resource;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import org.aoju.bus.core.consts.Charset;
import org.aoju.bus.core.io.resource.Resource;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.IoUtils;

public class StringResource
implements Resource {
    private String data;
    private String name;
    private java.nio.charset.Charset charset;

    public StringResource(String data) {
        this(data, null);
    }

    public StringResource(String data, String name) {
        this(data, name, Charset.UTF_8);
    }

    public StringResource(String data, String name, java.nio.charset.Charset charset) {
        this.data = data;
        this.name = name;
        this.charset = charset;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getUrl() {
        return null;
    }

    @Override
    public InputStream getStream() {
        return new ByteArrayInputStream(this.readBytes());
    }

    @Override
    public BufferedReader getReader(java.nio.charset.Charset charset) {
        return IoUtils.getReader(new StringReader(this.data));
    }

    @Override
    public String readStr(java.nio.charset.Charset charset) throws InstrumentException {
        return this.data;
    }

    @Override
    public String readUtf8Str() throws InstrumentException {
        return this.data;
    }

    @Override
    public byte[] readBytes() throws InstrumentException {
        return this.data.getBytes(this.charset);
    }
}

