/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.binding.apache.cxf.interceptor;

import java.util.List;
import java.util.Map;
import org.aoju.bus.tracer.Backend;
import org.aoju.bus.tracer.config.TraceFilterConfiguration;
import org.aoju.bus.tracer.consts.TraceConsts;
import org.aoju.bus.tracer.transport.HttpHeaderTransport;
import org.aoju.bus.tracer.transport.SoapHeaderTransport;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

abstract class AbstractTraceInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTraceInInterceptor.class);
    protected final Backend backend;
    private final HttpHeaderTransport httpJsonSerializer;
    private final SoapHeaderTransport httpSoapSerializer;
    private final TraceFilterConfiguration.Channel channel;
    private String profile;

    public AbstractTraceInInterceptor(String phase, TraceFilterConfiguration.Channel channel, Backend backend, String profile) {
        super(phase);
        this.channel = channel;
        this.backend = backend;
        this.profile = profile;
        this.httpJsonSerializer = new HttpHeaderTransport();
        this.httpSoapSerializer = new SoapHeaderTransport();
    }

    protected abstract boolean shouldHandleMessage(Message var1);

    public void handleMessage(Message message) {
        if (this.shouldHandleMessage(message)) {
            TraceFilterConfiguration filterConfiguration = this.backend.getConfiguration(this.profile);
            LOGGER.debug("Interceptor handles message!");
            if (filterConfiguration.shouldProcessContext(this.channel)) {
                if (Boolean.TRUE.equals(message.getExchange().get((Object)"org.apache.cxf.rest.message"))) {
                    this.handleHttpMessage(message, filterConfiguration);
                } else {
                    try {
                        this.handleSoapMessage((SoapMessage)message, filterConfiguration);
                    }
                    catch (NoClassDefFoundError e) {
                        LOGGER.error("Should handle SOAP-message but it seems that cxf soap dependency is not on the classpath. Unable to parse Builder-Headers: {}", (Object)e.getMessage(), (Object)e);
                    }
                }
            }
        }
    }

    private void handleHttpMessage(Message message, TraceFilterConfiguration filterConfiguration) {
        List TraceHeader;
        Map requestHeaders = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
        if (requestHeaders != null && !requestHeaders.isEmpty() && (TraceHeader = (List)requestHeaders.get("TPIC")) != null && !TraceHeader.isEmpty()) {
            Map<String, String> parsedContext = this.httpJsonSerializer.parse(TraceHeader);
            this.backend.putAll(filterConfiguration.filterDeniedParams(parsedContext, this.channel));
        }
    }

    private void handleSoapMessage(SoapMessage message, TraceFilterConfiguration filterConfiguration) {
        Header soapHeader = message.getHeader(TraceConsts.SOAP_HEADER_QNAME);
        if (soapHeader != null) {
            Map<String, String> parsedContext = this.httpSoapSerializer.parseTpicHeader((Element)soapHeader.getObject());
            this.backend.putAll(filterConfiguration.filterDeniedParams(parsedContext, this.channel));
        }
    }
}

