/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.binding.spring.http;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.aoju.bus.tracer.Backend;
import org.aoju.bus.tracer.Builder;
import org.aoju.bus.tracer.config.TraceFilterConfiguration;
import org.aoju.bus.tracer.transport.HttpHeaderTransport;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public final class TraceClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private final Backend backend;
    private final HttpHeaderTransport transportSerialization;
    private final String profile;

    public TraceClientHttpRequestInterceptor() {
        this(Builder.getBackend(), new HttpHeaderTransport(), "default");
    }

    public TraceClientHttpRequestInterceptor(String profile) {
        this(Builder.getBackend(), new HttpHeaderTransport(), profile);
    }

    public TraceClientHttpRequestInterceptor(Backend backend, HttpHeaderTransport transportSerialization, String profile) {
        this.backend = backend;
        this.transportSerialization = transportSerialization;
        this.profile = profile;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        this.preRequest(request);
        ClientHttpResponse response = execution.execute(request, body);
        this.postResponse(response);
        return response;
    }

    private void preRequest(HttpRequest request) {
        TraceFilterConfiguration filterConfiguration = this.backend.getConfiguration(this.profile);
        if (!this.backend.isEmpty() && filterConfiguration.shouldProcessContext(TraceFilterConfiguration.Channel.OutgoingRequest)) {
            Map<String, String> filteredParams = filterConfiguration.filterDeniedParams(this.backend.copyToMap(), TraceFilterConfiguration.Channel.OutgoingRequest);
            request.getHeaders().add("TPIC", this.transportSerialization.render(filteredParams));
        }
    }

    private void postResponse(ClientHttpResponse response) {
        TraceFilterConfiguration filterConfiguration;
        List headers = response.getHeaders().get((Object)"TPIC");
        if (headers != null && (filterConfiguration = this.backend.getConfiguration(this.profile)).shouldProcessContext(TraceFilterConfiguration.Channel.IncomingResponse)) {
            this.backend.putAll(filterConfiguration.filterDeniedParams(this.transportSerialization.parse(headers), TraceFilterConfiguration.Channel.IncomingResponse));
        }
    }
}

