/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.boot.banner;

import com.taobao.text.Color;
import com.taobao.text.Decoration;
import com.taobao.text.ui.Element;
import com.taobao.text.ui.LabelElement;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;
import org.aoju.bus.boot.banner.AbstractBanner;

public class LogoBanner
extends AbstractBanner {
    private int elementCount;
    private int elementLineCount;
    private Color[] elementColors;
    private boolean boldOff;

    public LogoBanner(Class<?> resourceClass, String resourceLocation, String defaultBanner, int elementCount, int elementLineCount, Color[] elementColors, boolean boldOff) {
        super(resourceClass, resourceLocation, defaultBanner);
        this.elementCount = elementCount;
        this.elementLineCount = elementLineCount;
        this.elementColors = elementColors;
        this.boldOff = boldOff;
        this.initialize();
    }

    @Override
    protected String generateBanner(String bannerText) {
        if (bannerText != null) {
            StringBuilder stringBuilder = new StringBuilder();
            String[] elementTexts = new String[this.elementCount];
            int i = 0;
            int j = 0;
            for (String line : bannerText.split("\n")) {
                stringBuilder.append(line);
                stringBuilder.append("\n");
                if (i++ != this.elementLineCount - 1) continue;
                elementTexts[j++] = stringBuilder.toString();
                i = 0;
                stringBuilder.setLength(0);
            }
            LabelElement[] labelElements = new LabelElement[this.elementCount];
            for (int k = 0; k < this.elementCount; ++k) {
                labelElements[k] = this.boldOff ? Element.label((String)elementTexts[k]).style(Decoration.bold_off.fg(this.elementColors[k])) : Element.label((String)elementTexts[k]).style(Decoration.bold.fg(this.elementColors[k]));
            }
            TableElement tableElement = new TableElement();
            tableElement.row((Element[])labelElements);
            return RenderUtil.render((Element)tableElement);
        }
        return this.defaultBanner;
    }
}

