/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.file;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import org.aoju.bus.core.io.file.FileWrapper;
import org.aoju.bus.core.io.file.LineSeparator;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.CommonException;
import org.aoju.bus.core.utils.CharsetUtils;
import org.aoju.bus.core.utils.FileUtils;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.StringUtils;

public class FileWriter
extends FileWrapper {
    public FileWriter(File file, Charset charset) {
        super(file, charset);
        this.checkFile();
    }

    public FileWriter(File file, String charset) {
        this(file, CharsetUtils.charset(charset));
    }

    public FileWriter(String filePath, Charset charset) {
        this(FileUtils.file(filePath), charset);
    }

    public FileWriter(String filePath, String charset) {
        this(FileUtils.file(filePath), CharsetUtils.charset(charset));
    }

    public FileWriter(File file) {
        this(file, DEFAULT_CHARSET);
    }

    public FileWriter(String filePath) {
        this(filePath, DEFAULT_CHARSET);
    }

    public static FileWriter create(File file, Charset charset) {
        return new FileWriter(file, charset);
    }

    public static FileWriter create(File file) {
        return new FileWriter(file);
    }

    public File write(String content, boolean isAppend) throws CommonException {
        BufferedWriter writer = null;
        try {
            writer = this.getWriter(isAppend);
            writer.write(content);
            writer.flush();
        }
        catch (IOException e) {
            throw new CommonException(e);
        }
        finally {
            IoUtils.close(writer);
        }
        return this.file;
    }

    public File write(String content) throws CommonException {
        return this.write(content, false);
    }

    public File append(String content) throws CommonException {
        return this.write(content, true);
    }

    public <T> File writeLines(Collection<T> list) throws CommonException {
        return this.writeLines(list, false);
    }

    public <T> File appendLines(Collection<T> list) throws CommonException {
        return this.writeLines(list, true);
    }

    public <T> File writeLines(Collection<T> list, boolean isAppend) throws CommonException {
        return this.writeLines(list, null, isAppend);
    }

    public <T> File writeLines(Collection<T> list, LineSeparator lineSeparator, boolean isAppend) throws CommonException {
        try (PrintWriter writer = this.getPrintWriter(isAppend);){
            for (T t : list) {
                if (null == t) continue;
                writer.print(t.toString());
                this.printNewLine(writer, lineSeparator);
                writer.flush();
            }
        }
        return this.file;
    }

    public File writeMap(Map<?, ?> map, String kvSeparator, boolean isAppend) throws CommonException {
        return this.writeMap(map, null, kvSeparator, isAppend);
    }

    public File writeMap(Map<?, ?> map, LineSeparator lineSeparator, String kvSeparator, boolean isAppend) throws CommonException {
        if (null == kvSeparator) {
            kvSeparator = " = ";
        }
        try (PrintWriter writer = this.getPrintWriter(isAppend);){
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                if (null == entry) continue;
                writer.print(StringUtils.format("{}{}{}", entry.getKey(), kvSeparator, entry.getValue()));
                this.printNewLine(writer, lineSeparator);
                writer.flush();
            }
        }
        return this.file;
    }

    public File write(byte[] data, int off, int len) throws CommonException {
        return this.write(data, off, len, false);
    }

    public File append(byte[] data, int off, int len) throws CommonException {
        return this.write(data, off, len, true);
    }

    public File write(byte[] data, int off, int len, boolean isAppend) throws CommonException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(FileUtils.touch(this.file), isAppend);
            out.write(data, off, len);
            out.flush();
        }
        catch (IOException e) {
            try {
                throw new CommonException(e);
            }
            catch (Throwable throwable) {
                IoUtils.close(out);
                throw throwable;
            }
        }
        IoUtils.close(out);
        return this.file;
    }

    public File writeFromStream(InputStream in) throws CommonException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(FileUtils.touch(this.file));
            IoUtils.copy(in, (OutputStream)out);
        }
        catch (IOException e) {
            try {
                throw new CommonException(e);
            }
            catch (Throwable throwable) {
                IoUtils.close(out);
                throw throwable;
            }
        }
        IoUtils.close(out);
        return this.file;
    }

    public BufferedOutputStream getOutputStream() throws CommonException {
        try {
            return new BufferedOutputStream(new FileOutputStream(FileUtils.touch(this.file)));
        }
        catch (IOException e) {
            throw new CommonException(e);
        }
    }

    public BufferedWriter getWriter(boolean isAppend) throws CommonException {
        try {
            return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(FileUtils.touch(this.file), isAppend), this.charset));
        }
        catch (Exception e) {
            throw new CommonException(e);
        }
    }

    public PrintWriter getPrintWriter(boolean isAppend) throws CommonException {
        return new PrintWriter(this.getWriter(isAppend));
    }

    private void checkFile() throws CommonException {
        Assert.notNull(this.file, "File to write content is null !", new Object[0]);
        if (this.file.exists() && !this.file.isFile()) {
            throw new CommonException("File [{}] is not a file !", this.file.getAbsoluteFile());
        }
    }

    private void printNewLine(PrintWriter writer, LineSeparator lineSeparator) {
        if (null == lineSeparator) {
            writer.println();
        } else {
            writer.print(lineSeparator.getValue());
        }
    }
}

